#ifndef ALTNEKOMONITORLOGGER_H
#define ALTNEKOMONITORLOGGER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOMonitorLogger.h 1358 2008-04-21 03:23:18Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOMonitorLogger.h
 * \brief   NEKO Network Monitor Logger
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altLog.h>
#include <altBase/altLoopThread.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO Netowrk Monitor Logger
///
class altNEKOMonitorLogger : private altBaseLog
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNEKOMonitorLogger();
  
  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOMonitorLogger();

  ///
  /// \brief  Start
  ///
  /// \param  sFileName [I ] File Name
  /// \param  nPort     [I ] Port NO
  /// \param  bHeader   [I ] Print Header or Not
  /// \param  nInterval [I ] Write interval (msec)
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t Start(const altStr & sFileName, altInt nPort, altBool bHeader = true, DWORD nInterval = 60 * 1000);

  ///
  /// \brief  Stop
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Stop();

  ///
  /// \brief  Memory log write thread
  ///
  /// \param  pParam  [I ] this object
  ///
  LIBALT_API static alt_t WriteThread(void * pParam);

protected:
  ///
  /// \brief  Open log file
  ///
  /// \param  sFileName [I ] file name
  /// \param  sMode     [I ] file open mode
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Open(const altStr & sFileName, const altStr & sMode = "a+c");

  ///
  /// \brief  Write to log file
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Write();

  ///
  /// \brief  Close log file
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Close();

private:
  altLoopThread   m_oLoopThread;
  altInt          m_nPort;
  altBool         m_bHeader;
};

#endif
