/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOPacket.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOPacket.cpp
 * \brief   NEKO Network Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNEKOPacket.h"
#include "altBase/altMem.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altNEKOPacket::altNEKOPacket() :
m_pData (),
m_nSize (0),
m_pConnection (NULL)
{
}

///
/// \brief  Destructor
///
LIBALT_API altNEKOPacket::~altNEKOPacket()
{
  m_nSize = 0;
  m_pConnection = NULL;
}

///
/// \brief  Set Data
///
/// \param  pNEKOConnection [I ] NET Connection
/// \param  pData           [I ] network data
/// \param  nSize           [I ] data size
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altNEKOPacket::Set(const altCNEKOConnectionPtr & pNEKOConnection, const altCharPtr & pData, const altUInt nSize)
{
  ALT_P_ASSERT (pData != NULL);
  m_pData = pData;
  m_nSize = nSize;
  m_pConnection = pNEKOConnection;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Data
///
/// \param  pNEKOConnection [ O] NEKO Connection
/// \param  pData           [ O] network data
/// \param  nSize           [ O] data size
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altNEKOPacket::Get(altCNEKOConnectionPtr & pNEKOConnection, altCharPtr & pData, altUInt & nSize)
{
  pData = m_pData;
  nSize = m_nSize;
  pNEKOConnection = m_pConnection;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Compress
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altNEKOPacket::Compress()
{
  alt_t status;

  status = m_oBzip2.Compress (m_pData, m_nSize);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Decompress
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altNEKOPacket::Decompress()
{
  alt_t status;

  status = m_oBzip2.Decompress (m_pData, m_nSize);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}
