#ifndef ALTNEKOPACKET_H
#define ALTNEKOPACKET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOPacket.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOPacket.h
 * \brief   NEKO Network Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOConnection.h>
#include <altMisc/altBzip2.h>
#include <altBase/altCharPtr.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO Network Packet Data Class
///
class altNEKOPacket : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNEKOPacket();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOPacket();

  ///
  /// \brief  Set Data
  ///
  /// \param  pNEKOConnection [I ] NET Connection
  /// \param  pData           [I ] network data
  /// \param  nSize           [I ] data size
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  /// \return ALT_E_INVAL   invalid paramter
  ///
  LIBALT_API alt_t Set(const altCNEKOConnectionPtr & pNEKOConnection, const altCharPtr & pData, const altUInt nSize);

  ///
  /// \brief  Get Data
  ///
  /// \param  pNETConnection  [ O] NET Connection
  /// \param  pData           [ O] network data
  /// \param  nSize           [ O] data size
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Get(altCNEKOConnectionPtr & pNEKOConnection, altCharPtr & pData, altUInt & nSize);

  ///
  /// \brief  Compress
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Compress();

  ///
  /// \brief  Decompress
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Decompress();

protected:
  altCharPtr            m_pData;
  altUInt               m_nSize;
  altCNEKOConnectionPtr m_pConnection;
  altBzip2              m_oBzip2;
};
#endif  //ALTPACKET_H
