#ifndef ALTNEKORECEIVER_H
#define ALTNEKORECEIVER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOReceiver.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOReceiver.h
 * \brief   NEKO Network Data Receiver
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOConnectionManager.h>
#include <altNeko/altNEKOConnection.h>
#include <altNeko/altNEKORequestInvoker.h>
#include <altMisc/altQue.h>
#include <altBase/altSyncThread.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef alt_t (* altNEKOReceiveCallBack)(const altCNEKOConnectionPtr & pConnection, const altCharPtr & pData, const altUInt nSize);
typedef std::map<SOCKET, altCNEKOConnectionPtr> altNEKOConnectionMap;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO Receiver Class
///
class altNEKOReceiver : public altBase, public altSyncThread, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  pReceiveCallBackFunc  [I ] Receive Call Back Function
  /// \param  nThreadCount          [I ] Request Thread Count
  ///
  LIBALT_API altNEKOReceiver(const altNEKOReceiveCallBack pReceiveCallBackFunc, const altUInt nThreadCount);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOReceiver();

  ///
  /// \brief  Add Connection
  ///
  /// \param  pConnection [I ] NET Connection
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_I_MAX       max
  ///
  LIBALT_API alt_t Add(const altCNEKOConnectionPtr & pConnection);

  ///
  /// \brief  Del Connection
  ///
  /// \param  pConnection [I ] NET Connection
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_S_NOT_FOUND not found
  ///
  LIBALT_API alt_t Del(const altCNEKOConnectionPtr & pConnection);

  ///
  /// \brief  Get Size
  ///
  /// \return content size
  ///
  LIBALT_API altUInt Size() const;

  ///
  /// \brief  Start Receive Thread
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t Start();

  ///
  /// \brief  Stop Receiver Thread
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Stop();

  ///
  /// \brief  Pop received packet
  ///
  /// \param  pPacket [ O] pointer of packet
  ///
  /// \return ALT_S_SUCCESS     success
  /// \return ALT_S_NOT_FOUND   not data
  ///
  LIBALT_API alt_t Pop(altNEKOPacket * & pPacket);

  ///
  /// \brief  Delete all client connection
  ///
  LIBALT_API void DelAllClient();

  ///
  /// \brief  Get packet count
  ///
  /// \return Packet count
  ///
  LIBALT_API altUInt GetPacketCount() const;

protected:
  ///
  /// \brief  receive thread
  ///
  /// \param  pParam  [I ] altNETReceiver object
  ///
  LIBALT_API static alt_t ReceiveThread(void * pParam);
  
  altNEKOPacketQue        m_oPacketQue;       ///< Packet Que
  altNEKOConnectionMap    m_oConnectionMap;   ///< NEKO Connection Map
  altLoopThread           m_oReceiveThreaed;  ///< Receive Thread
  altNEKORequestInvoker   m_oRequestInvoker;  ///< Request Invoker
};
#endif  //ALTNETNETRECEIVER_H
