#ifndef ALTNEKOREQUEST_H
#define ALTNEKOREQUEST_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKORequest.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETRequest.h
 * \brief   Request
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOConnection.h>
#include <altMisc/altQue.h>
#include <altBase/altPtr.h>
#include <altBase/altMem.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef alt_t (* altNEKOReceiveCallBack)(const altCNEKOConnectionPtr & pConnection, const altCharPtr & pData, const altUInt nSize);

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Request Infomation Class
///
class altNEKORequest : public altBase, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  altNEKORequest();

  ///
  /// \brief  Destructor
  ///
  virtual ~altNEKORequest();

  altStr                  m_sFuncName;
  altNEKOReceiveCallBack  m_pReceiveCallBackFunc;   ///< Call Back Function
  altCNEKOConnectionPtr   m_pConnection;            ///< NEKO Connection
  altCharPtr              m_pData;                  ///< Received Data
  altUInt                 m_nSize;                  ///< Received Data Size
};

#endif  //ALTNEKOREQUEST_H
