/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKORequestInvoker.cpp 1375 2008-04-25 08:20:32Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETRequestInvoker.cpp
 * \brief   Request Invoker
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNEKORequestInvoker.h"
#include "altNet/altNETServerConnection.h"
#include "altBase/altUtil.h"
#include "altBase/altThread.h"


/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
/// \param  oPacketQue [I ] Packet Que
///
LIBALT_API altNEKORequestInvoker::altNEKORequestInvoker(altNEKOPacketQue & oPacketQue, const altNEKOReceiveCallBack pReceiveCallBackFunc, const altUInt nThreadCount) :
m_oRequestQue(),
m_oRequestThreadContainer(),
m_oPacketQue (oPacketQue),
m_oRequestInvoker(10),
m_pReceiveCallBackFunc (pReceiveCallBackFunc)
{
  m_oRequestInvoker.Start (altNEKORequestInvoker::RequestInvokerThread, this);

  for (altUInt i = 0; i < nThreadCount; i++) {
    altLoopThread * pRequestThread = ALT_NEW altLoopThread (20);
    pRequestThread->Start (altNEKORequestInvoker::RequestThread, this);
    m_oRequestThreadContainer.push_back (pRequestThread);
  }
}

///
/// \brief  Destructor
///
LIBALT_API altNEKORequestInvoker::~altNEKORequestInvoker()
{
  m_oRequestInvoker.Stop();
  for (altNEKORequestThreadContainer::iterator i = m_oRequestThreadContainer.begin(); i != m_oRequestThreadContainer.end(); i++) {
    (* i)->Stop();
    delete (* i);
  }
  m_oRequestThreadContainer.clear();
}

///
/// \brief  Restart threads
///
/// \\return  ALT_S_SUCCESS success
///
LIBALT_API alt_t altNEKORequestInvoker::ReStart()
{
  for (altUInt i = 0; i < m_oRequestThreadContainer.size(); i++) {
    m_oRequestThreadContainer[i]->StopNoWait();
  }
  m_oRequestInvoker.StopNoWait();
  altSleep (100);
  m_oRequestInvoker.Start (altNEKORequestInvoker::RequestInvokerThread, this);
  for (altUInt i = 0; i < m_oRequestThreadContainer.size(); i++) {
    m_oRequestThreadContainer[i]->Start(altNEKORequestInvoker::RequestThread, this);
  }
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Request Invoker Thread
///
/// \param  pParam  [IO] altNETRequestInvoker object
///
LIBALT_API alt_t altNEKORequestInvoker::RequestInvokerThread(void * pParam)
{
  altNEKORequestInvoker * pInvoker = (altNEKORequestInvoker *)pParam;
  altNEKOReceiveCallBack  pCallBackFunc = pInvoker->m_pReceiveCallBackFunc;
  alt_t                   status;
  altNEKOPacketQue &      oPacketQue = pInvoker->m_oPacketQue;
  altNEKOPacket *         pPacket = NULL;

  status = oPacketQue.Pop (pPacket);
  if (status == ALT_S_SUCCESS) {
    altNEKORequest *   pRequest = ALT_NEW altNEKORequest();
    pRequest->m_pReceiveCallBackFunc = pCallBackFunc;
    pPacket->Get (pRequest->m_pConnection, pRequest->m_pData, pRequest->m_nSize);
    delete pPacket;
    pInvoker->m_oRequestQue.Push (pRequest);
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Request Thread
///
/// \param  pParam  [I ] Request Infomation
///
LIBALT_API alt_t altNEKORequestInvoker::RequestThread(void * pParam)
{
  altNEKORequestInvoker *   pInvoker = (altNEKORequestInvoker *)pParam;
  altNEKORequest *          pRequest = NULL;

  pInvoker->m_oRequestQue.Pop (pRequest);

  if (pRequest != NULL) {
#if 0
    if (pRequest->m_pConnection->IsServerConnection()) {
      const altCNETServerConnectionPtr & pServerConnection = (altCNETServerConnectionPtr &)pRequest->m_pConnection; 
      alt_t status = pServerConnection->CallReceiveCallBack (pRequest->m_pData, pRequest->m_nSize);
      ALT_LOG (status);
    }
    else {
      pRequest->m_pReceiveCallBackFunc (pRequest->m_pConnection, pRequest->m_pData, pRequest->m_nSize);
    }
#endif
    pRequest->m_pReceiveCallBackFunc (pRequest->m_pConnection, pRequest->m_pData, pRequest->m_nSize);
    delete pRequest;
  }

  ALT_RET (ALT_S_SUCCESS);
}
