#ifndef ALTNEKOREQUESTINVOKER_H
#define ALTNEKOREQUESTINVOKER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKORequestInvoker.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKORequestInvoker.h
 * \brief   NEKO Request Invoker
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOConnection.h>
#include <altNeko/altNEKORequest.h>
#include <altNeko/altNEKOPacket.h>
#include <altMisc/altQue.h>
#include <altBase/altLoopThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef altQue<altNEKOPacket *>       altNEKOPacketQue;                 ///< Packet Que
typedef altQue<altNEKORequest *>      altNEKORequestQue;                ///< Request Que
typedef std::vector<altLoopThread *>  altNEKORequestThreadContainer;    ///< Request Thread Container

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Request Invoker Class
///
class altNEKORequestInvoker : public altBase, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  oPacketQue            [I ] Packet Que
  /// \param  pReceiveCallBackFunc  [I ] Receive Call Back Func
  /// \param  nThreadCount          [I ] Request Thread Count
  ///
  LIBALT_API altNEKORequestInvoker(altNEKOPacketQue & oPacketQue, const altNEKOReceiveCallBack pReceiveCallBackFunc, const altUInt nThreadCount);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKORequestInvoker();

  ///
  /// \brief  Restart threads
  ///
  /// \\return  ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t ReStart();

protected:
  ///
  /// \brief  Request Invoker Thread
  ///
  /// \param  pParam  [IO] altNETRequestInvoker object
  ///
  LIBALT_API static alt_t RequestInvokerThread(void * pParam);

  ///
  /// \brief  Request Thread
  ///
  /// \param  pParam  [I ] Request Infomation
  ///
  LIBALT_API static alt_t RequestThread(void * pParam);

  altNEKORequestQue             m_oRequestQue;              ///< Request Que
  altNEKORequestThreadContainer m_oRequestThreadContainer;  ///< Request Thread Container
  altNEKOPacketQue &            m_oPacketQue;               ///< Packet Que
  altLoopThread                 m_oRequestInvoker;          ///< Request invoker thread
  altNEKOReceiveCallBack        m_pReceiveCallBackFunc;     ///< NEKO Receive Call Back Function
};

#endif  //ALTNETREQUESTINVOKER_H
