#ifndef ALTNEKOSENDER_H
#define ALTNEKOSENDER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOSender.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOSender.h
 * \brief   NEKO Network Sender
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOConnection.h>
#include <altMisc/altQue.h>
#include <altBase/altCharPtr.h>
#include <altBase/altPtr.h>
#include <altBase/altLoopThread.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altNEKOConnection;
class altNEKOPacket;

typedef const altNEKOConnection     altCNEKOConnection;     ///< const altNETConnection
typedef altPtr<altNEKOConnection>   altNEKOConnectionPtr;   ///< pointer of altNEKOConnection
typedef altPtr<altCNEKOConnection>  altCNEKOConnectionPtr;  ///< pointer of const altNEKOConnection

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO Sender
///
class altNEKOSender : public altBase, protected altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNEKOSender();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOSender();

  ///
  /// \brief  Send
  ///
  /// \param  pConnection [I ] Connection
  /// \param  pData       [I ] Data
  /// \param  nSize       [I ] Data Size
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Send(const altCNEKOConnectionPtr & pConnection, const altCharPtr & pData, const altInt nSize) const;

  ///
  /// \brief  Start Send Thread
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Start();

  ///
  /// \brief  Stop Send Thread
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Stop();

  ///
  /// \brief  Get packet count
  ///
  /// \return Packet count
  ///
  LIBALT_API altUInt GetPacketCount() const;

protected:
  ///
  /// \brief  Send Thread
  ///
  /// \param  pParam  [I ] altNETSender object
  ///
  LIBALT_API static alt_t SendThread(void * pParam);

  mutable altQue<altNEKOPacket *> m_oPacketQue;   ///< send packet queue
  altLoopThread                   m_oSendThread;  ///< send thread
};
#endif  //ALTNETNETSENDER_H

