/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altClientPacket.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altClientPacket.cpp
 * \brief   Client Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altClientPacket.h"
#include "altBase/altMem.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altClientPacket::altClientPacket() :
m_pData(),
m_nSize(0)
{
}

///
/// \brief  Destructor
///
LIBALT_API altClientPacket::~altClientPacket()
{
  m_nSize = 0;
}

///
/// \brief  Set Data
///
/// \param  pData           [I ] Data
/// \param  nSize           [I ] Data Size
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altClientPacket::Set(const altCharPtr & pData, const altUInt nSize)
{
  m_pData = pData;
  m_nSize = nSize;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Data
///
/// \return Data
///
LIBALT_API const altCharPtr altClientPacket::GetData() const
{
  return (m_pData);
}

///
/// \brief  Get Size
///
/// \return Size
///
LIBALT_API altUInt altClientPacket::GetSize() const
{
  return (m_nSize);
}

///
/// \brief  Compress
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altClientPacket::Compress()
{
  alt_t     status;

  status = m_oBzip2.Compress (m_pData, m_nSize);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Decompress
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altClientPacket::Decompress()
{
  alt_t status;

  status = m_oBzip2.Decompress (m_pData, m_nSize);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}
