#ifndef ALTCLIENTPACKET_H
#define ALTCLIENTPACKET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altClientPacket.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPPacket.h
 * \brief   Network Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altMisc/altBzip2.h>
#include <altBase/altCharPtr.h>
#include <altBase/altStatus.h>
#include <altBase/altLog.h>
#include <altBase/altBase.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Client Packet Data
///
class altClientPacket : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altClientPacket();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altClientPacket();

  ///
  /// \brief  Set Data
  ///
  /// \param  pData           [I ] Data
  /// \param  nSize           [I ] Data Size
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  /// \return ALT_E_INVAL   invalid paramter
  ///
  LIBALT_API alt_t Set(const altCharPtr & pData, const altUInt nSize);

  ///
  /// \brief  Get Data
  ///
  /// \return Data
  ///
  LIBALT_API const altCharPtr GetData() const;

  ///
  /// \brief  Get Size
  ///
  /// \return Size
  ///
  LIBALT_API altUInt GetSize() const;

  ///
  /// \brief  Compress
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Compress();

  ///
  /// \brief  Decompress
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Decompress();

protected:
  altCharPtr  m_pData;  ///< Data
  altUInt     m_nSize;  ///< Data Size
  altBzip2    m_oBzip2; ///< Bzip2
};
#endif  //ALTCLIENTPACKET_H
