/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETPacket.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETPacket.cpp
 * \brief   Network Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNETPacket.h"
#include "altBase/altMem.h"
/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altNETPacket::altNETPacket() :
m_pData (),
m_nSize (0),
m_pConnection (NULL)
{
}

///
/// \brief  Destructor
///
LIBALT_API altNETPacket::~altNETPacket()
{
  m_nSize = 0;
  m_pConnection = NULL;
}

///
/// \brief  Set Data
///
/// \param  pNETConnection  [I ] NET Connection
/// \param  pData           [I ] network data
/// \param  nSize           [I ] data size
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altNETPacket::Set(const altCNETConnectionPtr & pNETConnection, const altCharPtr & pData, const altUInt nSize)
{
  ALT_P_ASSERT (pData != NULL);
  m_pData = pData;
  m_nSize = nSize;
  m_pConnection = pNETConnection;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Data
///
/// \param  pNETConnection  [ O] NET Connection
/// \param  pData           [ O] network data
/// \param  nSize           [ O] data size
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altNETPacket::Get(altCNETConnectionPtr & pNETConnection, altCharPtr & pData, altUInt & nSize)
{
  pData = m_pData;
  nSize = m_nSize;
  pNETConnection = m_pConnection;

  ALT_RET (ALT_S_SUCCESS);
}
