#ifndef ALTNETREQUEST_H
#define ALTNETREQUEST_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETRequest.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETRequest.h
 * \brief   Request
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETConnection.h>
#include <altMisc/altQue.h>
#include <altBase/altPtr.h>
#include <altBase/altMem.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef alt_t(* altNETReceiveCallBack)(const altCNETConnectionPtr &, const altCharPtr &, const altUInt); ///< Call Back Data Receive Function

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Request Infomation Class
///
class altNETRequest : public altBase, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  altNETRequest();

  ///
  /// \brief  Destructor
  ///
  virtual ~altNETRequest();

  altNETReceiveCallBack   m_pReceiveCallBackFunc;   ///< Call Back Function
  altCNETConnectionPtr    m_pConnection;            ///< NET Connection
  altCharPtr              m_pData;                  ///< Received Data
  altUInt                 m_nSize;                  ///< Received Data Size
};

#endif  //ALTNETREQUEST_H
