#ifndef ALTNETSENDBROKER_H
#define ALTNETSENDBROKER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETSenderBroker.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETSendBroker.h
 * \brief   NET Network Send Broker
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETSender.h>
#include <altBase/altPtr.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altNETConnectionManager;
class altNETConnection;
class altNETSender;

typedef std::vector<altNETSender *> altNETSenderContainer;


/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NET Send Broker
///
class altNETSenderBroker : public altBase, protected altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNETSenderBroker();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNETSenderBroker();

  ///
  /// \brief  Send
  ///
  /// \param  nSocket  [I ] socket
  /// \param  pData    [I ] data
  /// \param  nSize    [I ] data size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_NOMEM     out of memory
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Send(const altCNETConnectionPtr & pConnection, const altCharPtr & pData, const altInt nSize) const;

  ///
  /// \brief  Get sender count
  ///
  /// \return sender count
  ///
  LIBALT_API const altUInt GetSenderCount() const;

protected:
  ///
  /// \brief  Create New Sender
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t CreateNewSender() const;

  ///
  /// \brief  Deleter Thread
  ///
  /// \param  pParam  [IO] this object
  ///
  LIBALT_API static alt_t DeleterThread(void * pParam);

  mutable altNETSenderContainer     m_oNETSenderContainer;    ///< NET Sender Container
  altLoopThread                     m_oDeleterThread;         ///< Deleter Thread
};
#endif  //ALTNETNETSENDBROKER_H
