#ifndef ALTNETCOMMON_H
#define ALTNETCOMMON_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNetCommon.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNetCommon.h
 * \brief   Network Common Function
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_LINUX
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define ALT_NO_SSL  0x00    ///< No SSL
#define ALT_SSL_V23 0x01    ///< SSL ver2,3
#define ALT_SSL_V2  0x02    ///< SSL ver2
#define ALT_SSL_V3  0x03    ///< SSL ver3
#define ALT_TSL_V1  0x04    ///< TSL ver1

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
#ifdef ALT_LINUX
  typedef int                 SOCKET;
  typedef struct sockaddr     SOCKADDR;
  typedef struct sockaddr_in  SOCKADDR_IN;
  typedef struct hostent *    LPHOSTENT;
  typedef unsigned int *      LPIN_ADDR;
#endif


#endif  //ALTNETCOMMON_H

