/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLServerConnection.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSSLServerConnection.cpp
 * \brief   SSL Server Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSSLServerConnection.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
/// \param  pSSL            [I ] Pointer of SSL Object
/// \param  m_pSSLContext   [I ] Pointer of SSL Context Object
/// \param  nSocket         [I ] Socket
/// \param  oSockAddrIn     [I ] Internet socket address
/// \param  nAcceptedPortNo [I ] Accepted port number
/// \param  oSenderBroker   [I ] Sender broker
/// \param  oServerInfo     [I ] Server infomation
///
LIBALT_API altSSLServerConnection::altSSLServerConnection(SSL * pSSL, SSL_CTX * pSSLContext, const SOCKET nSocket, const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNETSenderBroker & oSenderBroker, const altNETServerInfo & oServerInfo) :
altSSLConnection (pSSL, pSSLContext, nSocket, oSockAddrIn, nAcceptedPortNo, oSenderBroker),
altNETServerConnection (oServerInfo)
{
  m_bServerConnection = true;
}

///
/// \brief  Destructor
///
LIBALT_API altSSLServerConnection::~altSSLServerConnection()
{
}
