#ifndef ALTSSLSERVERCONNECTION_H
#define ALTSSLSERVERCONNECTION_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLServerConnection.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSSLServerConnection.h
 * \brief   SSL Server Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETServerInfo.h>
#include <altNet/altNETServerConnection.h>
#include <altNet/altSSLConnection.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SSL Server Network Connection Class
///
class altSSLServerConnection : public altSSLConnection, public altNETServerConnection
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  pSSL            [I ] Pointer of SSL Object
  /// \param  m_pSSLContext   [I ] Pointer of SSL Context Object
  /// \param  nSocket         [I ] Socket
  /// \param  oSockAddrIn     [I ] Internet socket address
  /// \param  nAcceptedPortNo [I ] Accepted port number
  /// \param  oSenderBroker   [I ] Sender broker
  /// \param  oServerInfo     [I ] Server infomation
  ///
  LIBALT_API altSSLServerConnection(SSL * pSSL, SSL_CTX * pSSLContext, const SOCKET nSocket, const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNETSenderBroker & oSenderBroker, const altNETServerInfo & oServerInfo);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSSLServerConnection();

private:
  altNETServerInfo  m_oServerInfo;
};

#endif
