#ifndef altSSLSyncThread_H
#define altSSLSyncThread_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLSyncThread.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSSLSyncThread.h
 * \brief   SSL Synchronize Thread Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>
#include <vector>

//--------------------------------------------------------------------
// Type Definition
//--------------------------------------------------------------------
typedef std::vector<altSyncThread *> altSyncThreadContainer;

//--------------------------------------------------------------------
// Class Definition
//--------------------------------------------------------------------
///
/// \brief	 SSL Synchronize Class
///
class altSSLSyncThread
{
public:
	///
	/// \brief Constructor
	///
	altSSLSyncThread();

	///
	/// \brief Destructor
	///
	virtual ~altSSLSyncThread();

  ///
  /// \brief	Initialize
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
	static alt_t InitLock();

	///
	/// \brief	Lock Call Back Function
	///
	static void LockingCallback(altInt nMode, altInt nType, const altChar * pFile, altInt nLine);

	///
	/// \brief	end of using
	///
	/// \return ALT_S_SUCCESS	  Success
	///
	static alt_t End();

private:
  static altBool                bInitDone;
  static altSyncThreadContainer oSyncThreads;
};

#endif //altSSLSyncThread_H

