#ifndef ALTTCPACCEPTOR_H
#define ALTTCPACCEPTOR_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTCPAcceptor.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPAcceptor.h
 * \brief   Network Server Acceptor
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETSenderBroker.h>
#include <altNet/altNETReceiverBroker.h>
#include <altNet/altSocket.h>
#include <altNet/altNetCommon.h>
#include <altBase/altLoopThread.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef void (* altNETAcceptCallBack)(const altInt nPort, const altCNETConnectionPtr & pNETConnection);
typedef std::vector<altLoopThread *> altAcceptThreadContainer; ///< Accept Thread Container
class altTCPServer;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  network server class
///
class altTCPAcceptor : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  pReceiveCallBack    [I ] Receive call back function
  /// \param  nThreadCount        [I ] Reqeust thread count
  /// \param  nAcceptThreadCount  [I ] Accept thread count
  ///
  LIBALT_API altTCPAcceptor(const altNETReceiveCallBack pReceiveCallBack, const altUInt nThreadCount, const altUInt nAcceptThreadCount);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTCPAcceptor();

  ///
  /// \brief  Open Port
  ///
  /// \param  nPort               [I ] Port NO
  /// \param  nListenQueSize      [I ] Listen Queue Size
  /// \param  pAcceptCallBack     [I ] Accept Call Back Function
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_INVAL     parameter error
  /// \return ALT_E_SOCKET    create socket error
  /// \return ALT_E_BIND      bind error
  /// \return ALT_E_LISTEN    listen error
  ///
  LIBALT_API virtual alt_t OpenPort(const altInt nPort, const altInt nListenQueSize, const altNETAcceptCallBack pAcceptCallBack);

  ///
  /// \brief  Close Port
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t ClosePort();

  ///
  /// \brief  Accept Thread
  ///
  /// \param  pParam  [I ] parameter
  ///
  LIBALT_API static alt_t AcceptThread(void * pParam);

  ///
  /// \brief  Get sender count
  ///
  /// \return Sender count
  ///
  LIBALT_API const altUInt GetSenderCount() const;

protected:
  altNETReceiverBroker        m_oReceiverBroker;        ///< NET receiver broker
  altNETSenderBroker          m_oSenderBroker;          ///< NET send broker
  altNETAcceptCallBack        m_pAcceptCallBackFunc;    ///< accept call back function
  altInt                      m_nPort;                  ///< port no
  altSocket                   m_nListenSocket;          ///< listen socket
  altUInt                     m_nAcceptThreadCount;     ///< Accept Thread Count
  altAcceptThreadContainer    m_oAcceptThreadContainer; ///< Accept Thread Container
};

#endif  //ALTNETTCPACCEPTOR_H

