#ifndef ALTTCPSERVERCONNECTION_H
#define ALTTCPSERVERCONNECTION_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTCPServerConnection.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPServerConnection.h
 * \brief   TCP Server Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETServerInfo.h>
#include <altNet/altNETServerConnection.h>
#include <altNet/altTCPConnection.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Server Network Connection Class
///
class altTCPServerConnection : public altTCPConnection, public altNETServerConnection
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  nSocket         [I ] Socket
  /// \param  oSockAddrIn     [I ] Internet socket address
  /// \param  nAcceptedPortNo [I ] Accepted port number
  /// \param  oSenderBroker   [I ] Sender broker
  /// \param  oServerInfo     [I ] Server infomation
  ///
  LIBALT_API altTCPServerConnection(const SOCKET nSocket, const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNETSenderBroker & oSenderBroker, const altNETServerInfo & oServerInfo);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTCPServerConnection();

private:
  altNETServerInfo  m_oServerInfo;
};

#endif
