#ifndef ALTTCPSOCKET_H
#define ALTTCPSOCKET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTCPSocket.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPSocket.h
 * \brief   TCP Socket
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altSocket.h>
#include <altBase/altStr.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  TCP Socket Class
///
class altTCPSocket : public altSocket
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altTCPSocket();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTCPSocket();

  ///
  /// \brief  Connect
  ///
  /// \param  sHost [I ] Host name or IP address
  /// \param  nPort [I ] Port number
  ///
  /// \return ALT_S_SUCCESS       success
  /// \retrun ALT_E_CONNECT       connect error
  /// \return	ALT_E_SOCKET        create socket error
  /// \return ALT_E_UNKOWN_HOST   unknown host error
  ///
  LIBALT_API virtual alt_t Connect(const altStr & sHost, const altInt nPort);

  ///
  /// \brief  Disconnect
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t Disconnect();
};

#endif
