/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altOggPlay.cpp 1012 2008-03-28 03:28:03Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOClient.cpp
 * \brief   NEKO Network Client
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altOggPlay.h"
#include "altMisc/altFile.h"
#include <math.h>

altSyncThread altOggPlay::oSycnThread;


LIBALT_API altOggPlay::altOggPlay()
{
	stf=1;
	endf=1;
	fname_="";
}

LIBALT_API altOggPlay::~altOggPlay()
{
	Stop();
}

long altOggPlay::LoadOggVorbis(const char *file_name, int word, char **ogg)
{
	int eof=0;
	long size=0,data_size;
	FILE *fp;
	vorbis_info *vi;
	if(!(word == 1 || word == 2)){fprintf(stderr, "word is error");	return -1;}
	fp = fopen(file_name, "rb");
	if(fp == NULL){	fprintf(stderr, "Open Error : %s", file_name);	return -1;}
	/* OggVorbis */
	if(ov_open(fp, &vf, NULL, 0) < 0) {
      fprintf(stderr,"Input does not appear to be an Ogg bitstream.\n");
			fclose(fp); return -1;
	}else
		vi=ov_info(&vf,-1);

	whsize = sizeof(wh.ckidRIFF) + sizeof(wh.ckSizeRIFF) + sizeof(wh.fccType) + sizeof(wh.ckidFmt)  + sizeof(wh.ckSizeFmt)  + sizeof(wh.WaveFmt) + sizeof(wh.ckidData) + sizeof(wh.ckSizeData);

	data_size = (long)ceil(vi->channels * vi->rate * ov_time_total(&vf,-1) * word);
	dd=vi->channels * vi->rate*word;
	*ogg = (char *)malloc(whsize);
	if(ogg == NULL){
		free(ogg);
		ov_clear(&vf);
		fclose(fp);
		fprintf(stderr, "malloc Error\n");
		return -1;
	}
	/* wb_̏ */
	memcpy(wh.ckidRIFF, "RIFF", 4);
	wh.ckSizeRIFF = whsize + size - 8;
	memcpy(wh.fccType, "WAVE", 4);
	memcpy(wh.ckidFmt, "fmt ", 4);
	wh.ckSizeFmt = sizeof(WAVEFORMATEX);

	wh.WaveFmt.cbSize          = sizeof(WAVEFORMATEX);
	wh.WaveFmt.wFormatTag      = WAVE_FORMAT_PCM;
	wh.WaveFmt.nChannels       = vi->channels;
	wh.WaveFmt.nSamplesPerSec  = vi->rate;
	wh.WaveFmt.nAvgBytesPerSec = vi->rate * vi->channels * word;
	wh.WaveFmt.nBlockAlign     = vi->channels * word;
	wh.WaveFmt.wBitsPerSample  = word * 8;

	memcpy(wh.ckidData, "data", 4);
	wh.ckSizeData = size;

	/* ւ̃wb_̏ */
	int s = 0;
	memcpy(*ogg, &wh.ckidRIFF, sizeof(wh.ckidRIFF));          s += sizeof(wh.ckidRIFF);
	memcpy(*ogg + s, &wh.ckSizeRIFF, sizeof(wh.ckSizeRIFF));  s += sizeof(wh.ckSizeRIFF);
	memcpy(*ogg + s, &wh.fccType, sizeof(wh.fccType));        s += sizeof(wh.fccType);
	memcpy(*ogg + s, &wh.ckidFmt, sizeof(wh.ckidFmt));        s += sizeof(wh.ckidFmt);
	memcpy(*ogg + s, &wh.ckSizeFmt, sizeof(wh.ckSizeFmt));    s += sizeof(wh.ckSizeFmt);
	memcpy(*ogg + s, &wh.WaveFmt, sizeof(wh.WaveFmt));        s += sizeof(wh.WaveFmt);
	memcpy(*ogg + s, &wh.ckidData, sizeof(wh.ckidData));      s += sizeof(wh.ckidData);
	memcpy(*ogg + s, &wh.ckSizeData, sizeof(wh.ckSizeData));

	return data_size + whsize;
}

void altOggPlay::ReleaseOggVorbis(char **ogg)
{
    ov_clear(&vf);
	if(ogg!=NULL){
		free(*ogg);
		ogg=NULL;
	}
}

LIBALT_API void altOggPlay::Play(altStr & sFileName, double FadeSpeed)
{
	Stop();
	FadeSpeed_=FadeSpeed;
	FadeSpeedt_=0.0;
	fademode=TRUE;
	altStr s,b;
	altFile f;
  alt_t status;

  status = f.Open (sFileName, "rb");
  if (ALT_IS_ERR (status)) {
    return;
  }

	f.Close();		
	oggsize = LoadOggVorbis (sFileName.GetCStr(), 2, &ogg);
	loop1=loop2=lo=loc=0;
	if (vf.vc->comments==2) {
		altStr cc;
		cc = vf.vc->user_comments[0];

    altStrList vCommentList = cc.Separate ("=");
    if (vCommentList[0] == "LOOPSTART") {
      loop1 = vCommentList[1].ToInt();
    }

		cc = vf.vc->user_comments[1];
    vCommentList = cc.Separate ("=");
    if (vCommentList[0] == "LOOPLENGTH") {
      loop2 = vCommentList[1].ToInt();
    }
	}
	oggsize1=(loop1)*4;
	oggsize2=(loop2+loop1)*4+whsize;
	playl=whsize;
    wfx.wFormatTag = WAVE_FORMAT_PCM;
    wfx.nChannels = wh.WaveFmt.nChannels;
    wfx.nSamplesPerSec = wh.WaveFmt.nSamplesPerSec;
    wfx.wBitsPerSample = wh.WaveFmt.wBitsPerSample;
    wfx.nBlockAlign = wfx.nChannels * wfx.wBitsPerSample / 8;
    wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;
    wfx.cbSize = 0;

    mmRes = waveOutOpen(& hwo, WAVE_MAPPER, & wfx, (DWORD)(LPVOID)waveOutProc, (DWORD)this, CALLBACK_FUNCTION);
    if (mmRes != MMSYSERR_NOERROR) {
      OutputDebugString (L"WAVE Out Device Open Error!\n");
    }

	AllocOutputBuffer();
	stf=0;plf=1;poss=0;
	playwav();	playwav();	playwav();	playwav();	playwav();
}

//Đobt@m
BOOL altOggPlay::AllocOutputBuffer(void)
{
    for(int i = 0 ; i < OUTPUT_BUFFER_NUM ; i++){
        g_OutputBuffer[i]=(LPWAVEHDR)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, sizeof(WAVEHDR));
        if(g_OutputBuffer[i]){
            g_OutputBuffer[i]->lpData=(LPSTR)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, OUTPUT_BUFFER_SIZE);
            if(g_OutputBuffer[i]->lpData)
                g_OutputBuffer[i]->dwBufferLength = OUTPUT_BUFFER_SIZE;
        }
    }
    return TRUE;
}

//Đobt@J
void altOggPlay::FreeOutputBuffer(void)
{
    for(int i = 0 ; i < OUTPUT_BUFFER_NUM ; i++){
        if(g_OutputBuffer[i]){
            HeapFree(GetProcessHeap(), 0, g_OutputBuffer[i]);
            g_OutputBuffer[i] = NULL;
        }
    }
}
void altOggPlay::playwav()
{
    //f[^ǂݍ
	lo++;if( lo==OUTPUT_BUFFER_NUM) lo=0;
	DWORD dwDataLen = OUTPUT_BUFFER_SIZE;
	int rrr=mcopy(buf[lo],dwDataLen);
	if((int)dwDataLen != rrr){
		if(endf==1){
			dwDataLen=rrr;
			stf=1;
		}else{//[v
			loopcnt++;
			playl=whsize+oggsize1;
			mcopy(buf[lo]+rrr,(int)dwDataLen-rrr,TRUE,(ogg_int64_t)loop1);
		}
	}
	
	memcpy(g_OutputBuffer[lo]->lpData,buf[lo],dwDataLen);
    g_OutputBuffer[lo]->dwBufferLength = dwDataLen;
    
    //M
    mmRes = waveOutPrepareHeader (hwo, g_OutputBuffer[lo], sizeof(WAVEHDR));
    if (mmRes != MMSYSERR_NOERROR) {
        OutputDebugString (L"Error in waveOutPrepareHeader\n");
        return;
    }

    //M
    mmRes = waveOutWrite(hwo, g_OutputBuffer[lo], sizeof(WAVEHDR));
    if(mmRes != MMSYSERR_NOERROR){
		OutputDebugString(L"Error in waveOutWrite ");
		switch(mmRes)
		{
		case MMSYSERR_INVALHANDLE:
	        OutputDebugString(L"MMSYSERR_INVALHANDLE\n");
			break;
		case MMSYSERR_NODRIVER:
	        OutputDebugString(L"MMSYSERR_NODRIVER\n");
			break;
		case MMSYSERR_NOMEM:
	        OutputDebugString(_T("MMSYSERR_NOMEM\n"));
			break;
		case WAVERR_UNPREPARED:
	        OutputDebugString(_T("WAVERR_UNPREPARED\n"));
			break;
		}
        return;
    }
}

VOID CALLBACK altOggPlay::waveOutProc(HWAVEOUT hwo,UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2)
{
    switch (uMsg) {
      case WOM_DONE:
        {
          oSycnThread.BeginLock();
          int loc_ = ((altOggPlay*)dwInstance)->loc;
          loc_++;

          if (loc_== OUTPUT_BUFFER_NUM) {
            loc_=0;
          }

          ((altOggPlay*)dwInstance)->loc=loc_;

          if (((altOggPlay*)dwInstance)->stf == 0) {
	          ((altOggPlay*)dwInstance)->playwav();
          }
          oSycnThread.EndLock();
        }
        break;
    }
}

LIBALT_API void altOggPlay::Stop(double FadeSpeed)
{
	if(ogg!=NULL)
	{
		FadeSpeed_=FadeSpeed;
		if(!(FadeSpeed==0.0 || FadeSpeed==1.0)){
			FadeSpeedt_=1.0; fademode=FALSE;
			return;
		}
    oSycnThread.BeginLock();
		stf = 1;
    oSycnThread.EndLock();

		waveOutReset(hwo);

    for(int i = 0 ; i < OUTPUT_BUFFER_NUM ; i++) {
			waveOutUnprepareHeader(hwo, g_OutputBuffer[i], sizeof(WAVEHDR));
    }
		waveOutClose(hwo);
		FreeOutputBuffer();
		plf=0;
		ReleaseOggVorbis(&ogg);
    for (altInt i = 0 ; i < OUTPUT_BUFFER_NUM ; i++) {
			ZeroMemory(buf[i],OUTPUT_BUFFER_SIZE);
    }
		ogg=NULL;
	}
}

//oggۂɃf[^l
int altOggPlay::mcopy(char* a,int len,BOOL seek,ogg_int64_t pos)
{
	int ret=0;
	int lenl=len;
	if(seek==TRUE){
		ov_pcm_seek(&vf,pos);
		poss=0;
	}
	if(playl+len > oggsize2) lenl=oggsize2 - playl;
	for(;;){
		ret = ov_read(&vf, (bufwav+poss), 4096, 0, 2, 1, &current_section);
		poss+=ret;
		if(ret==0) break;
		if(len<=poss)	break;
	}
	memcpy(a,bufwav,lenl);
	if(lenl<=poss)
	{
		poss-=lenl;
		if(poss!=0)
			memcpy(bufwav,bufwav+lenl,poss);
	}

	//fadevZ
	if(FadeSpeed_>0.0 && FadeSpeed_<1.0){
		short *b;
		short c;
		b=(short*)a;
		for(int i=0;i<lenl/2;i++){
			c=b[i];
			c=(short)((float)c * FadeSpeedt_);
			b[i]=c;
		}
		FadeSpeedt_+=FadeSpeed_*(fademode==FALSE?-1.0:1.0);
		if(FadeSpeedt_>0.9999&&fademode==TRUE) {FadeSpeed_=0.0;}//FadeIn
		if(FadeSpeedt_<0.0001&&fademode==FALSE){FadeSpeed_=0.0;Stop();}//FadeOut
	}
	playl+=lenl;
	return lenl;	
}

void altOggPlay::GetTime(int &mm,int &ss,int &sss)
{
	double t3=(double)playl/(double)(44100*2*2);
	int tt=(int)(t3*100.0);
	int t1=tt/100;
	mm=t1/60;
	ss=t1%60;
	sss=tt%100;
}

void altOggPlay::Pause(BOOL f)
{
	if(f==TRUE){
		if(ogg!=NULL)
			waveOutPause(hwo);
	}else{
		if(ogg!=NULL)
			waveOutRestart(hwo);
	}
}

void altOggPlay::ReStart(double FadeSpeed)
{
	if(fname_!="") Play(fname_,FadeSpeed);
}
