#ifndef ALTOGGPLAY_H
#define ALTOGGPLAY_H
/*--------------------------------------------------------------------------*

   Alternative Library

  $Id: altOggPlay.h 1012 2008-03-28 03:28:03Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altOggPlay.h
 * \brief   ogg play class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/

#include <altSound/vorbis/include/vorbis/codec.h>
#include <altSound/vorbis/include/vorbis/vorbisfile.h>
#include <altBase/altStr.h>
#include <altBase/altSyncThread.h>
#include <mmreg.h>
///
/// \brief WAVE file header
///
typedef struct{
	char          ckidRIFF[4];
	int           ckSizeRIFF;
	char          fccType[4];
	char          ckidFmt[4];
	int           ckSizeFmt;
	WAVEFORMATEX  WaveFmt;
	char          ckidData[4];
	int           ckSizeData;
} WAVEFILEHEADER;

#define BUFSZ			8192
#define OUTPUT_BUFFER_NUM   10
#define OUTPUT_BUFFER_SIZE  BUFSZ

class altOggPlay : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
	LIBALT_API altOggPlay();

  ///
  /// \brief  Destructor
  ///
	LIBALT_API virtual ~altOggPlay();

  ///
  /// \brief  Play
  /// FadeSpeed>=1.0  0.0or1.0->FadeIn OFF
  ///
	LIBALT_API void Play(altStr & sFileName, double FadeSpeed = 0.0);

  ///
  /// \brief  Stop
  /// FadeSpeed>=1.0 0.0or1.0->FadeOut OFF
  ///
	LIBALT_API void Stop(double FadeSpeed=0.0);

	void Pause(BOOL f);
	void ReStart(double FadeSpeed=0.0);
	void Loop(BOOL f){ endf=f^1; }
	BOOL GetLoop() {return endf^1; };
	void GetTime(int &mm,int &ss,int &sss);

	int stf;//vCtO 0:t 1:~
	
protected:	
	long LoadOggVorbis(const char *file_name, int word, char **ogg);
	void ReleaseOggVorbis(char **ogg);
	static VOID CALLBACK waveOutProc(HWAVEOUT hwo,UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2);
	BOOL AllocOutputBuffer();
	void FreeOutputBuffer(void);
	void playwav();
	int mcopy(char* a,int len,BOOL seek=FALSE,ogg_int64_t pos=0);

	WAVEFILEHEADER wh;
	WAVEFORMATEX wfx;
	char *ogg;
	OggVorbis_File vf;
	long whsize;
	int cc1,t,oggsize,dd,oggsize1,oggsize2,loop1,loop2;
	int lo,loc,endf,locs;
	int playl,ru2,ru;
	int poss,loopcnt,pl_no;
	int current_section;
	int plf,fademode;
	double FadeSpeed_,FadeSpeedt_;
	altStr fname_;

	MMRESULT    mmRes;
	HWAVEOUT    hwo;

	char bufwav[OUTPUT_BUFFER_SIZE+5000];
	char buf[OUTPUT_BUFFER_NUM][OUTPUT_BUFFER_SIZE];
	LPWAVEHDR  g_OutputBuffer[OUTPUT_BUFFER_NUM];

  static altSyncThread oSycnThread;
};

#endif
