#ifndef LIBALT_H
#define LIBALT_H
/*--------------------------------------------------------------------------*

   Alternative Library

  $Id: libalt.h 1366 2008-04-25 05:33:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    libalt.h
 * \brief   Alternative Library Header
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altExternalizable.h>
#include <altBase/altDataStream.h>
#include <altBase/altRuntime.h>
#include <altBase/altSignal.h>
#include <altBase/altCharPtr.h>
#include <altBase/altMemManager.h>
#include <altBase/altMem.h>
#include <altBase/altLog.h>
#include <altBase/altStr.h>
#include <altBase/altLoopThread.h>
#include <altBase/altThread.h>
#include <altBase/altStatus.h>
#include <altBase/altBaseMem.h>
#include <altBase/altSingleton.h>
#include <altBase/altUncopyable.h>
#include <altBase/altSyncThread.h>
#include <altBase/altUtil.h>
#include <altBase/altBase.h>

#include <altMisc/altTimer.h>
#include <altMisc/altMiscUtil.h>
#include <altMisc/altBlowFish.h>
#include <altMisc/altBzip2.h>
#include <altMisc/altProperty.h>
#include <altMisc/altSHA1.h>
#include <altMisc/altMD5.h>
#include <altMisc/altMemLogger.h>
#include <altMisc/altFile.h>
#include <altMisc/altQue.h>
#include <altMisc/altClock.h>
#include <altMisc/altDict.h>
#include <altMisc/altDir.h>
#include <altMisc/altWinMutex.h>
#include <altMisc/altProccess.h>

#include <altNet/altTCPServer.h>
#include <altNet/altTCPClient.h>
#include <altNet/altSSLServer.h>
#include <altNet/altSSLClient.h>

#include <altDB/altDBConnection.h>
#include <altDB/altDBConnectionPtr.h>
#include <altDB/altDBManager.h>
#include <altDB/altDBResultSet.h>
#include <altDB/altPreparedStatement.h>
#include <altDB/altSQL.h>
#include <altDB/altSQLLoader.h>

#include <altDB/altMySQL.h>

#include <altNeko/altNEKOServer.h>
#include <altNeko/altNEKOClient.h>
#include <altNeko/altNEKOMonitorLogger.h>

#if defined(ALT_WIN) && defined(USE_ALTDX)
  #include <altDX/altDX.h>
  #include <altDX/altDXInput.h>
  #include <altDX/alt2DQuad.h>
  #include <altDX/altDXFont.h>
  #include <altDX/altComponent.h>
  #include <altDX/altIME.h>
  #include <altDX/altIMEComponent.h>
  #include <altDX/altMouse.h>
  #include <altDX/altPolygon.h>
  #include <altDX/altXFile.h>
  #include <altDX/altLight.h>
  #include <altDX/altFontManager.h>
  #include <altDX/Component/altLabel.h>
  #include <altDX/Component/altTextBox.h>
#endif

#endif  //LIBALT_H
