/*--------------------------------------------------------------------------*

  Alternative Llibrary Sample

  $Id: main.cpp 1293 2008-04-12 10:32:44Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    main.cpp
 * \brief   altNEKOClient Sample
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <libalt.h>

/*----------------------------------------------------------------*
 * Structure Definition
 *----------------------------------------------------------------*/
typedef std::vector<altNEKOClient *> altNEKOClientContainer;

/*----------------------------------------------------------------*
 * Static functions declare
 *----------------------------------------------------------------*/
///
/// \brief  receive call back
///
/// \param  oClient     [IO] Client
/// \param  sFuncName   [I ] Remote function name
/// \param  dwSessionID [I ] Session ID
/// \param  oDataStream [IO] Data stream
/// \param  pParam      [I ] Call back paramter
///
static alt_t altClientRecvCallBack(altNEKOClient & oClient, const altStr & sFuncName, const DWORD dwSessionID, altDataStream & oDataStream);

///
/// \brief  disconnect call back
///
/// \param  oClient [IO] Client
///
static alt_t altClientDisconnectCallBack(altNEKOClient & oClient);

/*----------------------------------------------------------------*
 * Static variables
 *----------------------------------------------------------------*/
static altProperty oSetting;

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  main
///
/// \param  argc  [I ] arguments count
/// \param  argv  [I ] arguments
///
/// \return 0
///
int main(int argc, char * argv[])
{
  alt_t       status;

  status = oSetting.Load ("altNEKOClient.conf");
  ALT_LOG (status);

  aiLog.SetOutLevel (oSetting.GetStr ("LOG_LEVEL", "debug"));

  altNEKOClientContainer  oClients;

  for (altInt i = 0; i < oSetting.GetInt("CLIENT.COUNT", 100); i++) {
    altNEKOClient * pClient = ALT_NEW altNEKOClient (altClientRecvCallBack, altClientDisconnectCallBack);
    if (pClient == NULL) {
      continue;
    }
    oClients.push_back (pClient);
  }

  for (altNEKOClientContainer::iterator i = oClients.begin(); i != oClients.end(); i++) {
    if ((* i) == NULL) {
      continue;
    }
    status = (* i)->Connect (oSetting.GetStr("SERVER", "localhost"), oSetting.GetUInt ("PORT", 5432));
    if (ALT_IS_ERR (status)) {
      delete (* i);
      (* i) = NULL;
      continue;
    }
  }

  for (altUInt i = 0; i < oSetting.GetUInt ("SEND.COUNT", 100); i++) {
    for (altNEKOClientContainer::iterator i = oClients.begin(); i != oClients.end(); i++) {
      if ((* i) == NULL) {
        continue;
      }
      altDataStream oDataStream;

      altClock oClock;
      status = oDataStream.Write (oClock);
      if (ALT_IS_ERR (status)) {
        ALT_LOG (status);
        continue;
      }

      altChar * pData = NULL;
      status = ALT_MALLOC (pData, oSetting.GetUInt ("DATA.SIZE", 10000));
      if (ALT_IS_ERR (status)) {
        ALT_LOG (status);
        continue;
      }

      status = oDataStream.Write (pData, oSetting.GetUInt ("DATA.SIZE", 10000));
      if (ALT_IS_ERR (status)) {
        ALT_LOG (status);
        continue;
      }

      ALT_FREE (pData);

      status = (* i)->Send ("Echo", oDataStream);
    }
    altSleep (oSetting.GetULong ("SEND.INTERVAL", 100));
  }

  altBool bWait = true;
  // wait
  while (bWait) {
    altSleep (1000);
    bWait = false;
    for (altNEKOClientContainer::iterator i = oClients.begin(); i != oClients.end(); i++) {
      if ((* i)->Connected()) {
        bWait = true;
        if ((* i)->GetRecvSessionID() + 1 == oSetting.GetUInt ("SEND.COUNT", 100)) {
          status = (* i)->Disconnect();
          ALT_LOG (status);
        }
      }
    }
  }

  return (0);
}

/*----------------------------------------------------------------*
 * Static functions implements
 *----------------------------------------------------------------*/
///
/// \brief  receive call back
///
/// \param  oClient     [IO] Client
/// \param  sFuncName   [I ] Remote function name
/// \param  dwSessionID [I ] Session ID
/// \param  oDataStream [IO] Data stream
/// \param  pParam      [I ] Call back paramter
///
static alt_t altClientRecvCallBack(altNEKOClient & oClient, const altStr & sFuncName, const DWORD dwSessionID, altDataStream & oDataStream)
{
  alt_t       status;
  altClock    oClock;
  altCharPtr  pData;
  altUInt     nDataSize;
  
  status = oDataStream.Read (oClock);
  ALT_ERR_RET (status);

  status = oDataStream.Read (pData, nDataSize);
  ALT_ERR_RET (status);

  printf ("dwSessionID=%lu ResponseTime=(%5.1f)sec\n", dwSessionID, oClock.Elapsed());
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  disconnect call back
///
/// \param  oClient [IO] Client
///
static alt_t altClientDisconnectCallBack(altNEKOClient & oClient)
{
  printf ("Disconnect %s:%u", oClient.GetIP().GetCStr(), oClient.GetPort());
  ALT_RET (ALT_S_SUCCESS);
}
