/*--------------------------------------------------------------------------*

  Alternative Llibrary Sample

  $Id: main.cpp 864 2008-02-20 20:06:17Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    main.cpp
 * \brief   altNEKOServer Sample
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <libalt.h>

/*----------------------------------------------------------------*
 * Structure Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Static functions
 *----------------------------------------------------------------*/
///
/// \brief  Accept Call Back Function
///
/// \param  nPort           [I ] Port Number
/// \param  pNetConnection  [I ] Connection
/// 
static alt_t AcceptCallBack(const altInt nPort, const altCNEKOConnectionPtr & pNetConnection);

///
/// \brief  Disconnect Call Back Function
///
/// \param  pNetConnection  [I ] Connection
///
static alt_t DisconnectedCallBack(const altCNEKOConnectionPtr & pNetConnection);

/**
 * \brief memory end signature broken detected handler
 *
 * [parameter]
 * 	const altMemInfo &	...	freed address's memory management infomation
 * 	const altChar *	...	free called source file name
 * 	const altUInt	...	free called source file's line number
 */
static void altMemOverWriteDetectedHandle(const altMemInfo & oMemInfo, const altChar * szFileName, const altUInt nLine);


///
/// \brief  echo
///
/// \param  pNETConnection  [I ] connection
/// \param  pData           [I ] data
/// \param  nSize           [I ] data size
///
/// \return ALT_S_SUCCESS   success
///
static alt_t Echo(const altCNEKOConnectionPtr & pConnection, altDataStream & oDataStream, altDataStream & oReturnDataStream)
{
  alt_t       status;
  altCharPtr  pData = NULL;

  status = oDataStream.GetIndexData (pData);
  ALT_ERR_RET (status);

  status = oReturnDataStream.AddData ((altChar *)pData, oDataStream.GetIndexDataSize());
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

/*----------------------------------------------------------------*
 * Static variables
 *----------------------------------------------------------------*/
static const altRemoteFuncDef st_aRemoteFuncTable[] = {
  ALT_REMOTE_FUNC_ENT (Echo),
};

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  main
///
/// \param  argc  [I ] arguments count
/// \param  argv  [I ] arguments
///
/// \return 0
///
int main(int argc, char * argv[])
{
  alt_t       status;
  altProperty oSetting;

  altSetMemOverWriteDetectedHandler (altMemOverWriteDetectedHandle);

  status = oSetting.Load ("altNEKOServer.conf");
  ALT_LOG (status);

  aiLog.SetOutLevel (oSetting.GetStr ("LOG_LEVEL", "debug"));
  status = aiNEKOServer.OpenPort (oSetting.GetInt ("PORT", 5432), st_aRemoteFuncTable, ALT_ARRAY_SIZE (st_aRemoteFuncTable), AcceptCallBack, DisconnectedCallBack, oSetting.GetUInt ("THREAD_COUNT", 10));
  if (ALT_IS_ERR (status)) {
    ALT_LOG (status);
    return (1);
  }
  aiMemLogger.Start ("../Log/altNEKOServer/MemoryLog.log", 10 * 1000);

  while (1) {
    try {
      altSleep (1000);
      printf ("---------------------------------------------\n");
      printf ("Connection         = %u\n", aiNEKOConnectionManager.Size());
      printf ("memory size        = %u\n", aiMemManager.GetTotalSize());
      printf ("memory real size   = %u\n", aiMemManager.GetTotalRealSize());
      printf ("memory block count = %u\n", aiMemManager.GetBlockCount());
      printf ("port[%d] receive[%u] send[%u]\n", oSetting.GetInt ("PORT", 5432), aiNEKOServer.GetReceiverPacketCount (oSetting.GetInt ("PORT", 5432)), aiNEKOServer.GetSenerPacketCount (oSetting.GetInt ("PORT", 5432)));
      printf ("---------------------------------------------\n");
    }
    catch (...) {

    }
  }
}

///
/// \brief  Accept Call Back Function
///
/// \param  nPort           [I ] Port Number
/// \param  pNETConnection  [I ] Connection
/// 
static alt_t AcceptCallBack(const altInt nPort, const altCNEKOConnectionPtr & pNETConnection)
{
  printf ("Accept [%d] %s:%d\n", nPort, pNETConnection->GetIP().GetCStr(), pNETConnection->GetPort());
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Disconnect Call Back Function
///
/// \param  pNETConnection  [I ] Connection
///
static alt_t DisconnectedCallBack(const altCNEKOConnectionPtr & pNETConnection)
{
  printf ("Disconnect %s:%d\n", pNETConnection->GetIP().GetCStr(), pNETConnection->GetPort());
  ALT_RET (ALT_S_SUCCESS);
}

/**
 * \brief memory end signature broken detected handler
 *
 * [parameter]
 * 	const altMemInfo &	...	freed address's memory management infomation
 * 	const altChar *	...	free called source file name
 * 	const altUInt	...	free called source file's line number
 */
static void altMemOverWriteDetectedHandle(const altMemInfo & oMemInfo, const altChar * szFileName, const altUInt nLine)
{
#ifdef _DEBUG
  printf ("Alloc(%s:%u) Free(%s:%u)\n", oMemInfo.m_szFileName.c_str(), oMemInfo.m_nLine, szFileName, nLine);
#else
  printf ("Free(%s:%u)\n", szFileName, nLine);
#endif
  exit (1);
}
