#!/bin/sh
#
#
#  Alternative Llibrary Sample
#
#  $Id: build.sh 837 2008-02-17 10:44:56Z nekosys $
#
#  Copyright (C) 2008 NEKO SYSTEM
# 
#
function clean()
{
  rm -f altNEKOClient/debug/*.o
  rm -f altNEKOClient/release/*.o
  rm -f altNEKOServer/debug/*.o
  rm -f altNEKOServer/release/*.o
  rm -f ../debug/altNEKOClient.exe
  rm -f ../release/altNEKOClient.exe
  rm -f ../debug/altNEKOServer.exe
  rm -f ../release/altNEKOServer.exe
}

function make_obj_debug()
{
  cat ../Makefile.header.debug > Makefile.debug
  cat Makefile.footer >> Makefile.debug
  make -f Makefile.debug
}

function make_obj_release()
{
  cat ../Makefile.header.release > Makefile.release
  cat Makefile.footer >> Makefile.release
  make -f Makefile.release 
}

function build()
{
  # build altNEKOClient
  cd altNEKOClient
  make -f Makefile.debug
  make -f Makefile.release
  cd ..
  
  # build altNEKOServer
  cd altNEKOServer
  make -f Makefile.debug
  make -f Makefile.release
  cd ..
}

if [ "$1" = "clean" ]; then
  clean;
elif [ "$1" = "rebuild" ]; then
  clean;
  build;
else
  build;
fi
