#ifndef TEST5_1_H
#define TEST5_1_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: Test5_1.h 1300 2008-04-13 04:09:20Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    Test5_1.h
 * \brief   DirectX Test 5-1
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <libalt.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DirectX Test 5-1
///
class Test5_1 : public altComponent
{
public:
  ///
  /// \brief  Constructor
  ///
  Test5_1();

  ///
  /// \brief  Destructor
  ///
  ~Test5_1();

  ///
  /// \brief  Render
  ///
  /// \param  pd3dDevice  [I ] D3D Device
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  alt_t Render(IDirect3DDevice9 * pDevice);

private:
  altXFile  m_oXFile;
};

///
/// \brief  DirectX Test 5-1
///
class Test5_1_Panel : public altComponent
{
public:
  ///
  /// \brief  Constructor
  ///
  Test5_1_Panel();

  ///
  /// \brief  Destructor
  ///
  ~Test5_1_Panel();

  ///
  /// \brief  Render
  ///
  /// \param  pd3dDevice  [I ] D3D Device
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  alt_t Render(IDirect3DDevice9 * pDevice);

private:
  Test5_1 m_o1;
  Test5_1 m_o2;
  Test5_1 m_o3;
};

#endif
