/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.plugins.report.XmlReportParser$SaxXmlReportParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class XmlReportParser$SaxXmlReportParser$XmlReportParserHandler
extends DefaultHandler {
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private int position;
    private Date pubdate;
    private boolean skip;
    private ModuleRevisionId mrid;
    private boolean isDefault;
    private SortedMap revisionsMap;
    private List revisionArtifacts;
    private final XmlReportParser$SaxXmlReportParser this$0;

    private XmlReportParser$SaxXmlReportParser$XmlReportParserHandler(XmlReportParser$SaxXmlReportParser saxXmlReportParser, byte by) {
        this.this$0 = saxXmlReportParser;
        this.revisionsMap = new TreeMap();
        this.revisionArtifacts = null;
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("module".equals(string3)) {
            this.organisation = attributes.getValue("organisation");
            this.module = attributes.getValue("name");
            return;
        }
        if ("revision".equals(string3)) {
            Object object;
            int n;
            this.revisionArtifacts = new ArrayList();
            this.branch = attributes.getValue("branch");
            this.revision = attributes.getValue("name");
            this.isDefault = Boolean.valueOf(attributes.getValue("default"));
            String string4 = attributes.getValue("position");
            if (string4 == null) {
                XmlReportParser$SaxXmlReportParser$XmlReportParserHandler xmlReportParser$SaxXmlReportParser$XmlReportParserHandler = this;
                n = (xmlReportParser$SaxXmlReportParser$XmlReportParserHandler.revisionsMap.isEmpty() ? -1 : (Integer)xmlReportParser$SaxXmlReportParser$XmlReportParserHandler.revisionsMap.keySet().toArray()[xmlReportParser$SaxXmlReportParser$XmlReportParserHandler.revisionsMap.size() - 1]) + 1;
            } else {
                n = this.position = Integer.valueOf(string4).intValue();
            }
            if (attributes.getValue("error") != null || attributes.getValue("evicted") != null) {
                this.skip = true;
                return;
            }
            this.revisionsMap.put(new Integer(this.position), this.revisionArtifacts);
            this.mrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision, IvyNodeUsage.getExtraAttributes(attributes, "extra-"));
            XmlReportParser$SaxXmlReportParser.access$000(this.this$0).add(this.mrid);
            if (this.isDefault) {
                XmlReportParser$SaxXmlReportParser.access$100(this.this$0).add(this.mrid);
            } else {
                object = DefaultArtifact.newIvyArtifact(this.mrid, this.pubdate);
                MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport((Artifact)object);
                XmlReportParser$SaxXmlReportParser.access$200(this.this$0).put(this.mrid, metadataArtifactDownloadReport);
                XmlReportParser$SaxXmlReportParser.access$300(this.this$0).add(this.mrid);
            }
            try {
                object = attributes.getValue("pubdate");
                if (object != null) {
                    this.pubdate = Ivy.DATE_FORMAT.parse((String)object);
                }
                this.skip = false;
                return;
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("invalid publication date for " + this.organisation + " " + this.module + " " + this.revision + ": " + attributes.getValue("pubdate"));
            }
        }
        if ("metadata-artifact".equals(string3)) {
            if (this.skip) {
                return;
            }
            MetadataArtifactDownloadReport metadataArtifactDownloadReport = (MetadataArtifactDownloadReport)XmlReportParser$SaxXmlReportParser.access$200(this.this$0).get(this.mrid);
            if (metadataArtifactDownloadReport != null) {
                metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.fromString(attributes.getValue("status")));
                metadataArtifactDownloadReport.setDownloadDetails(attributes.getValue("details"));
                metadataArtifactDownloadReport.setSize(Long.parseLong(attributes.getValue("size")));
                metadataArtifactDownloadReport.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                metadataArtifactDownloadReport.setSearched(XmlReportParser$SaxXmlReportParser.access$400(attributes.getValue("searched")));
                if (attributes.getValue("location") != null) {
                    metadataArtifactDownloadReport.setLocalFile(new File(attributes.getValue("location")));
                }
                if (attributes.getValue("original-local-location") != null) {
                    metadataArtifactDownloadReport.setOriginalLocalFile(new File(attributes.getValue("original-local-location")));
                }
                if (attributes.getValue("origin-location") != null) {
                    if (ArtifactOrigin.isUnknown(attributes.getValue("origin-location"))) {
                        metadataArtifactDownloadReport.setArtifactOrigin(ArtifactOrigin.unkwnown(metadataArtifactDownloadReport.getArtifact()));
                        return;
                    }
                    metadataArtifactDownloadReport.setArtifactOrigin(new ArtifactOrigin(metadataArtifactDownloadReport.getArtifact(), XmlReportParser$SaxXmlReportParser.access$400(attributes.getValue("origin-is-local")), attributes.getValue("origin-location")));
                }
            }
            return;
        }
        if ("artifact".equals(string3)) {
            if (this.skip) {
                return;
            }
            String string5 = attributes.getValue("status");
            String string6 = attributes.getValue("name");
            String string7 = attributes.getValue("type");
            String string8 = attributes.getValue("ext");
            DefaultArtifact defaultArtifact = new DefaultArtifact(this.mrid, this.pubdate, string6, string7, string8, IvyNodeUsage.getExtraAttributes(attributes, "extra-"));
            ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(defaultArtifact);
            artifactDownloadReport.setDownloadStatus(DownloadStatus.fromString(string5));
            artifactDownloadReport.setDownloadDetails(attributes.getValue("details"));
            artifactDownloadReport.setSize(Long.parseLong(attributes.getValue("size")));
            artifactDownloadReport.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
            if (attributes.getValue("location") != null) {
                artifactDownloadReport.setLocalFile(new File(attributes.getValue("location")));
            }
            this.revisionArtifacts.add(artifactDownloadReport);
            return;
        }
        if ("origin-location".equals(string3)) {
            if (this.skip) {
                return;
            }
            ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)this.revisionArtifacts.get(this.revisionArtifacts.size() - 1);
            if (ArtifactOrigin.isUnknown(attributes.getValue("location"))) {
                artifactDownloadReport.setArtifactOrigin(ArtifactOrigin.unkwnown(artifactDownloadReport.getArtifact()));
                return;
            }
            artifactDownloadReport.setArtifactOrigin(new ArtifactOrigin(artifactDownloadReport.getArtifact(), XmlReportParser$SaxXmlReportParser.access$400(attributes.getValue("is-local")), attributes.getValue("location")));
            return;
        }
        if ("info".equals(string3)) {
            String string9 = attributes.getValue("organisation");
            String string10 = attributes.getValue("module");
            String string11 = attributes.getValue("branch");
            String string12 = attributes.getValue("revision");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string13 = attributes.getQName(i);
                if (!string13.startsWith("extra-")) continue;
                String string14 = string13.substring("extra-".length());
                String string15 = attributes.getValue(i);
                hashMap.put(string14, string15);
            }
            ModuleRevisionId.newInstance(string9, string10, string11, string12, hashMap);
        }
    }

    public final void endElement(String string, String string2, String string3) {
        if ("dependencies".equals(string3)) {
            Iterator iterator = this.revisionsMap.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                XmlReportParser$SaxXmlReportParser.access$600(this.this$0).addAll(list);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)iterator2.next();
                    if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) continue;
                    XmlReportParser$SaxXmlReportParser.access$700(this.this$0).add(artifactDownloadReport.getArtifact());
                }
            }
        }
    }

    XmlReportParser$SaxXmlReportParser$XmlReportParserHandler(XmlReportParser$SaxXmlReportParser xmlReportParser$SaxXmlReportParser) {
        this(xmlReportParser$SaxXmlReportParser, 0);
    }
}

