/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.$colon$colon;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import xsbt.boot.AppProperty;
import xsbt.boot.Application;
import xsbt.boot.BootException;
import xsbt.boot.BootSetup;
import xsbt.boot.Classifiers;
import xsbt.boot.ConfigurationParser$;
import xsbt.boot.IvyOptions;
import xsbt.boot.LaunchConfiguration;
import xsbt.boot.Line;
import xsbt.boot.ListMap;
import xsbt.boot.ListMap$;
import xsbt.boot.Logging;
import xsbt.boot.ParseLine$;
import xsbt.boot.Pre$;
import xsbt.boot.PromptProperty;
import xsbt.boot.PropertyInit;
import xsbt.boot.Repository;
import xsbt.boot.Search;
import xsbt.boot.Search$;
import xsbt.boot.SetProperty;
import xsbt.boot.Using$;
import xsbt.boot.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationParser {
    public volatile int bitmap$0;
    private Pattern propertyPattern;

    private final List readLine$1(List accum, int index, BufferedReader bufferedReader) {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            List<Line> list = ParseLine$.MODULE$.apply(line, index);
            ++index;
            accum = accum.$colon$colon$colon(list);
        }
        return accum.reverse();
    }

    public ListMap<String, ListMap<String, Option<String>>> processLines(List<Line> lines) {
        Tuple2 tuple2 = new Tuple2(ListMap$.MODULE$.empty().default(new $anonfun$10(this)), None$.MODULE$);
        Tuple2 s = lines.$div$colon(tuple2, new $anonfun$11(this));
        return s._1();
    }

    public List<String> trim(String[] s) {
        return new BoxedObjectArray(s).map(new $anonfun$trim$1(this)).toList();
    }

    public <T> T parsePropertyValue(String name, String definition, Function3<String, String, Option<String>, T> f) {
        Matcher m = this.propertyPattern().matcher(definition);
        if (m.matches()) {
            String optionalArg = m.group(3);
            return f.apply(m.group(1), m.group(2), optionalArg == null ? None$.MODULE$ : new Some<String>(optionalArg));
        }
        throw Pre$.MODULE$.error(new StringBuilder().append((Object)"Invalid property definition '").append((Object)definition).append((Object)"' for property '").append((Object)name).append((Object)"'").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pattern propertyPattern() {
        if ((this.bitmap$0 & 1) != 0) return this.propertyPattern;
        ConfigurationParser configurationParser = this;
        synchronized (configurationParser) {
            if ((this.bitmap$0 & 1) == 0) {
                this.propertyPattern = Pattern.compile("(.+)\\((.*)\\)(?:\\[(.*)\\])?");
                this.bitmap$0 |= 1;
            }
            return this.propertyPattern;
        }
    }

    public PropertyInit defineProperty(String name, String action, String requiredArg, Option<String> optionalArg) {
        block4: {
            PropertyInit propertyInit;
            block3: {
                String string;
                block2: {
                    String string2 = string = action;
                    String string3 = "prompt";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    propertyInit = new PromptProperty(requiredArg, optionalArg);
                    break block3;
                }
                String string4 = string;
                String string5 = "set";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                propertyInit = new SetProperty(requiredArg);
            }
            return propertyInit;
        }
        throw Pre$.MODULE$.error(new StringBuilder().append((Object)"Unknown action '").append((Object)action).append((Object)"' for property '").append((Object)name).append((Object)"'").toString());
    }

    public Tuple2<String, PropertyInit> parsePropertyDefinition(String name$2, String value) {
        String[] x;
        String[] stringArray = value.split("=", 2);
        Option option = Array$.MODULE$.unapplySeq(new BoxedObjectArray(stringArray));
        if (option.isEmpty()) {
            String[] stringArray2 = stringArray;
        } else {
            Object a = option.get();
            Seq seq = (Seq)(a instanceof Seq ? a : ScalaRunTime$.MODULE$.boxArray(a));
            if (seq.lengthCompare(2) == 0) {
                return new Tuple2<String, PropertyInit>((String)seq.apply(BoxesRunTime.boxToInteger(0)), (PropertyInit)this.parsePropertyValue(name$2, (String)seq.apply(BoxesRunTime.boxToInteger(1)), new $anonfun$parsePropertyDefinition$1(this, name$2)));
            }
            x = stringArray;
        }
        throw Pre$.MODULE$.error(new StringBuilder().append((Object)"Invalid property definition '").append(x).append((Object)"' for property '").append((Object)name$2).append((Object)"'").toString());
    }

    public List<AppProperty> getAppProperties(ListMap<String, Option<String>> m) {
        return m.toList().filter(new $anonfun$getAppProperties$1(this)).map(new $anonfun$getAppProperties$2(this));
    }

    public List<Repository> getRepositories(ListMap<String, Option<String>> m) {
        return m.toList().map(new $anonfun$getRepositories$1(this));
    }

    public Tuple2<Application, List<String>> getApplication(ListMap<String, Option<String>> listMap) {
        Tuple2<String, ListMap<String, Option<String>>> tuple2 = this.id(listMap, "org", "org.scala-tools.sbt");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, ListMap<String, Option<String>>> tuple22 = new Tuple2<String, ListMap<String, Option<String>>>(tuple2._1(), tuple2._2());
        String string = tuple22._1();
        ListMap<String, Option<String>> listMap2 = tuple22._2();
        Tuple2<String, ListMap<String, Option<String>>> tuple23 = this.id(listMap2, "name", "sbt");
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Tuple2<String, ListMap<String, Option<String>>> tuple24 = new Tuple2<String, ListMap<String, Option<String>>>(tuple23._1(), tuple23._2());
        String string2 = tuple24._1();
        ListMap<String, Option<String>> listMap3 = tuple24._2();
        Tuple2<Version, ListMap<String, Option<String>>> tuple25 = this.getVersion(listMap3, new StringBuilder().append((Object)string2).append((Object)" version").toString(), new StringBuilder().append((Object)string2).append((Object)".version").toString());
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        Tuple2<Version, ListMap<String, Option<String>>> tuple26 = new Tuple2<Version, ListMap<String, Option<String>>>(tuple25._1(), tuple25._2());
        Version version2 = tuple26._1();
        ListMap<String, Option<String>> listMap4 = tuple26._2();
        Tuple2<String, ListMap<String, Option<String>>> tuple27 = this.id(listMap4, "class", "xsbt.Main");
        if (tuple27 == null) {
            throw new MatchError(tuple27);
        }
        Tuple2<String, ListMap<String, Option<String>>> tuple28 = new Tuple2<String, ListMap<String, Option<String>>>(tuple27._1(), tuple27._2());
        String string3 = tuple28._1();
        ListMap<String, Option<String>> listMap5 = tuple28._2();
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple29 = this.ids(listMap5, "components", List$.MODULE$.apply(new BoxedObjectArray(new String[]{"default"})));
        if (tuple29 == null) {
            throw new MatchError(tuple29);
        }
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple210 = new Tuple2<List<String>, ListMap<String, Option<String>>>(tuple29._1(), tuple29._2());
        List<String> list = tuple210._1();
        ListMap<String, Option<String>> listMap6 = tuple210._2();
        Tuple2<String, ListMap<String, Option<String>>> tuple211 = this.id(listMap6, "cross-versioned", "true");
        if (tuple211 == null) {
            throw new MatchError(tuple211);
        }
        Tuple2<String, ListMap<String, Option<String>>> tuple212 = new Tuple2<String, ListMap<String, Option<String>>>(tuple211._1(), tuple211._2());
        String string4 = tuple212._1();
        ListMap<String, Option<String>> listMap7 = tuple212._2();
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple213 = this.ids(listMap7, "resources", Nil$.MODULE$);
        if (tuple213 == null) {
            throw new MatchError(tuple213);
        }
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple214 = new Tuple2<List<String>, ListMap<String, Option<String>>>(tuple213._1(), tuple213._2());
        List<String> list2 = tuple214._1();
        ListMap<String, Option<String>> listMap8 = tuple214._2();
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple215 = this.ids(listMap8, "classifiers", Nil$.MODULE$);
        if (tuple215 == null) {
            throw new MatchError(tuple215);
        }
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple216 = new Tuple2<List<String>, ListMap<String, Option<String>>>(tuple215._1(), tuple215._2());
        List<String> list3 = tuple216._1();
        ListMap<String, Option<String>> listMap9 = tuple216._2();
        this.check(listMap9, "label");
        Object object = ScalaRunTime$.MODULE$.arrayValue(Pre$.MODULE$.toArray(this.toFiles(list2)), File.class);
        File[] fileArray = (File[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, File.class) : object);
        Application application = new Application(string, string2, version2, string3, list, Pre$.MODULE$.toBoolean(string4), fileArray);
        return new Tuple2<Application, List<String>>(application, list3);
    }

    public Tuple2<Search, ListMap<String, Option<String>>> getSearch(ListMap<String, Option<String>> listMap, File file2) {
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple2;
        block4: {
            Tuple2<Search, ListMap<String, Option<String>>> tuple22;
            block3: {
                ListMap<String, Option<String>> listMap2;
                List<String> list;
                block2: {
                    tuple2 = this.ids(listMap, "search", Nil$.MODULE$);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    list = tuple2._1();
                    listMap2 = tuple2._2();
                    Nil$ nil$ = Nil$.MODULE$;
                    List<String> list2 = list;
                    if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block2;
                    tuple22 = new Tuple2<Search, ListMap<String, Option<String>>>(Search$.MODULE$.none(), listMap2);
                    break block3;
                }
                if (list instanceof $colon$colon) {
                    $colon$colon $colon$colon = ($colon$colon)list;
                    String string = (String)$colon$colon.hd$1();
                    List list3 = $colon$colon.tl$1();
                    Nil$ nil$ = Nil$.MODULE$;
                    List list4 = list3;
                    tuple22 = !(nil$ != null ? !nil$.equals(list4) : list4 != null) ? new Tuple2<Search, ListMap<String, Option<String>>>(Search$.MODULE$.apply(string, List$.MODULE$.apply(new BoxedObjectArray(new File[]{file2}))), listMap2) : new Tuple2<Search, ListMap<String, Option<String>>>(Search$.MODULE$.apply(string, this.toFiles(list3)), listMap2);
                }
                break block4;
            }
            return tuple22;
        }
        throw new MatchError(tuple2);
    }

    public Logging getLevel(Option<String> m) {
        return (Logging)m.map(new $anonfun$getLevel$1(this)).getOrElse(new $anonfun$getLevel$2(this));
    }

    public Logging getLogging(ListMap<String, Option<String>> listMap) {
        return (Logging)this.check("label", this.process(listMap, "level", new $anonfun$getLogging$1(this)));
    }

    public BootSetup getBoot(ListMap<String, Option<String>> listMap) {
        Tuple2<File, ListMap<String, Option<String>>> tuple2 = this.file(listMap, "directory", this.toFile("project/boot"));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<File, ListMap<String, Option<String>>> tuple22 = new Tuple2<File, ListMap<String, Option<String>>>(tuple2._1(), tuple2._2());
        File file2 = tuple22._1();
        ListMap<String, Option<String>> listMap2 = tuple22._2();
        Tuple2<File, ListMap<String, Option<String>>> tuple23 = this.file(listMap2, "properties", this.toFile("project/build.properties"));
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Tuple2<File, ListMap<String, Option<String>>> tuple24 = new Tuple2<File, ListMap<String, Option<String>>>(tuple23._1(), tuple23._2());
        File file3 = tuple24._1();
        ListMap<String, Option<String>> listMap3 = tuple24._2();
        Tuple2<Search, ListMap<String, Option<String>>> tuple25 = this.getSearch(listMap3, file3);
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        Tuple2<Search, ListMap<String, Option<String>>> tuple26 = new Tuple2<Search, ListMap<String, Option<String>>>(tuple25._1(), tuple25._2());
        Search search = tuple26._1();
        ListMap<String, Option<String>> listMap4 = tuple26._2();
        Tuple2<Boolean, ListMap<String, Option<String>>> tuple27 = this.bool(listMap4, "quick-option", false);
        if (tuple27 == null) {
            throw new MatchError(tuple27);
        }
        Tuple2<Boolean, ListMap<String, Option<String>>> tuple28 = new Tuple2<Boolean, ListMap<String, Option<String>>>(tuple27._1(), tuple27._2());
        boolean bl = BoxesRunTime.unboxToBoolean(tuple28._1());
        ListMap<String, Option<String>> listMap5 = tuple28._2();
        Tuple2<Boolean, ListMap<String, Option<String>>> tuple29 = this.bool(listMap5, "prompt-fill", false);
        if (tuple29 == null) {
            throw new MatchError(tuple29);
        }
        Tuple2<Boolean, ListMap<String, Option<String>>> tuple210 = new Tuple2<Boolean, ListMap<String, Option<String>>>(tuple29._1(), tuple29._2());
        boolean bl2 = BoxesRunTime.unboxToBoolean(tuple210._1());
        ListMap<String, Option<String>> listMap6 = tuple210._2();
        Tuple2<String, ListMap<String, Option<String>>> tuple211 = this.id(listMap6, "prompt-create", "");
        if (tuple211 == null) {
            throw new MatchError(tuple211);
        }
        Tuple2<String, ListMap<String, Option<String>>> tuple212 = new Tuple2<String, ListMap<String, Option<String>>>(tuple211._1(), tuple211._2());
        String string = tuple212._1();
        ListMap<String, Option<String>> listMap7 = tuple212._2();
        this.check(listMap7, "label");
        return new BootSetup(file2, file3, search, string, bl, bl2);
    }

    public Option<File> getIvy(ListMap<String, Option<String>> listMap) {
        Tuple2<File, ListMap<String, Option<String>>> tuple2 = this.file(listMap, "cache-directory", null);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<File, ListMap<String, Option<String>>> tuple22 = new Tuple2<File, ListMap<String, Option<String>>>(tuple2._1(), tuple2._2());
        File file2 = tuple22._1();
        ListMap<String, Option<String>> listMap2 = tuple22._2();
        this.check(listMap2, "label");
        return file2 == null ? None$.MODULE$ : new Some<File>(file2);
    }

    public Tuple2<File, ListMap<String, Option<String>>> file(ListMap<String, Option<String>> map, String name, File file2) {
        return new Tuple2<File, ListMap<String, Option<String>>>(Pre$.MODULE$.orElse(this.getOrNone(map, name).map(new $anonfun$file$1(this)), file2), map.$minus(name));
    }

    public File toFile(String string) {
        return new File(string.replace('/', File.separatorChar));
    }

    public List<File> toFiles(List<String> paths) {
        return paths.map(new $anonfun$toFiles$1(this));
    }

    public Tuple2<Boolean, ListMap<String, Option<String>>> bool(ListMap<String, Option<String>> map, String name, boolean bl) {
        Tuple2<String, ListMap<String, Option<String>>> tuple2 = this.id(map, name, ((Object)BoxesRunTime.boxToBoolean(bl)).toString());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, ListMap<String, Option<String>>> tuple22 = new Tuple2<String, ListMap<String, Option<String>>>(tuple2._1(), tuple2._2());
        String b = tuple22._1();
        ListMap<String, Option<String>> m = tuple22._2();
        return new Tuple2<Boolean, ListMap<String, Option<String>>>(BoxesRunTime.boxToBoolean(Pre$.MODULE$.toBoolean(b)), m);
    }

    public Tuple2<List<String>, ListMap<String, Option<String>>> ids(ListMap<String, Option<String>> map, String name, List<String> list) {
        Option result = map.apply(name).map(new $anonfun$8(this));
        return new Tuple2<List<String>, ListMap<String, Option<String>>>(Pre$.MODULE$.orElse(result, list), map.$minus(name));
    }

    public <K, V> Option<V> getOrNone(ListMap<K, Option<V>> map, K k) {
        return Pre$.MODULE$.orElse(map.get(k), None$.MODULE$);
    }

    public Tuple2<String, ListMap<String, Option<String>>> id(ListMap<String, Option<String>> map, String name, String string) {
        return new Tuple2<String, ListMap<String, Option<String>>>(Pre$.MODULE$.orElse(this.getOrNone(map, name), string), map.$minus(name));
    }

    public <T> T check(String label, Tuple2<T, ListMap<String, ?>> pair) {
        this.check(pair._2(), label);
        return pair._1();
    }

    public void check(ListMap<String, ?> listMap, String string) {
        if (listMap.isEmpty()) {
            return;
        }
        throw Pre$.MODULE$.error(listMap.keys().mkString(new StringBuilder().append((Object)"Invalid ").append((Object)string).append((Object)"(s): ").toString(), ",", ""));
    }

    public <K, V, T> Tuple2<T, ListMap<K, V>> process(ListMap<K, V> sections, K name, Function1<V, T> f) {
        return new Tuple2<T, ListMap<K, V>>(f.apply(sections.apply(name)), sections.$minus(name));
    }

    public <T> Tuple2<T, ListMap<String, ListMap<String, Option<String>>>> processSection(ListMap<String, ListMap<String, Option<String>>> sections, String name, Function1<ListMap<String, Option<String>>, T> f$1) {
        return this.process(sections, name, new $anonfun$processSection$1(this, f$1));
    }

    public Version version(String string, String string2) {
        if (Pre$.MODULE$.isEmpty(string2)) {
            throw Pre$.MODULE$.error(new StringBuilder().append((Object)string).append((Object)" cannot be empty (omit version declaration to use the default version)").toString());
        }
        Version version2 = null;
        try {
            version2 = (Version)this.parsePropertyValue(string, string2, new $anonfun$version$1(this));
        }
        catch (BootException bootException) {
            version2 = new Version.Explicit(string2);
        }
        return version2;
    }

    public Version processVersion(String label$2, String defaultName$2, Option<String> value) {
        return (Version)value.map(new $anonfun$processVersion$1(this, label$2)).getOrElse(new $anonfun$processVersion$2(this, defaultName$2));
    }

    public Tuple2<Version, ListMap<String, Option<String>>> getVersion(ListMap<String, Option<String>> listMap, String string, String string2) {
        return this.process(listMap, "version", new $anonfun$getVersion$1(this, string, string2));
    }

    public Tuple2<Version, List<String>> getScala(ListMap<String, Option<String>> listMap) {
        Tuple2<Version, ListMap<String, Option<String>>> tuple2 = this.getVersion(listMap, "Scala version", "scala.version");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<Version, ListMap<String, Option<String>>> tuple22 = new Tuple2<Version, ListMap<String, Option<String>>>(tuple2._1(), tuple2._2());
        Version version2 = tuple22._1();
        ListMap<String, Option<String>> listMap2 = tuple22._2();
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple23 = this.ids(listMap2, "classifiers", Nil$.MODULE$);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Tuple2<List<String>, ListMap<String, Option<String>>> tuple24 = new Tuple2<List<String>, ListMap<String, Option<String>>>(tuple23._1(), tuple23._2());
        List<String> list = tuple24._1();
        ListMap<String, Option<String>> listMap3 = tuple24._2();
        this.check(listMap3, "label");
        return new Tuple2<Version, List<String>>(version2, list);
    }

    public LaunchConfiguration processSections(ListMap<String, ListMap<String, Option<String>>> listMap) {
        Tuple2 tuple2 = this.processSection(listMap, "scala", new $anonfun$1(this));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        ListMap<String, ListMap<String, Option<String>>> listMap2 = tuple2._2();
        if (tuple22 == null) {
            throw new MatchError(tuple2);
        }
        Tuple3 tuple3 = new Tuple3(tuple22._1(), tuple22._2(), listMap2);
        Version version2 = (Version)tuple3._1();
        List list = (List)tuple3._2();
        ListMap<String, ListMap<String, Option<String>>> listMap3 = tuple3._3();
        Tuple2 tuple23 = this.processSection(listMap3, "app", new $anonfun$2(this));
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Tuple2 tuple24 = (Tuple2)tuple23._1();
        ListMap<String, ListMap<String, Option<String>>> listMap4 = tuple23._2();
        if (tuple24 == null) {
            throw new MatchError(tuple23);
        }
        Tuple3 tuple32 = new Tuple3(tuple24._1(), tuple24._2(), listMap4);
        Application application = (Application)tuple32._1();
        List list2 = (List)tuple32._2();
        ListMap<String, ListMap<String, Option<String>>> listMap5 = tuple32._3();
        Tuple2 tuple25 = this.processSection(listMap5, "repositories", new $anonfun$3(this));
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        Tuple2 tuple26 = new Tuple2(tuple25._1(), tuple25._2());
        List list3 = (List)tuple26._1();
        ListMap<String, ListMap<String, Option<String>>> listMap6 = tuple26._2();
        Tuple2 tuple27 = this.processSection(listMap6, "boot", new $anonfun$4(this));
        if (tuple27 == null) {
            throw new MatchError(tuple27);
        }
        Tuple2 tuple28 = new Tuple2(tuple27._1(), tuple27._2());
        BootSetup bootSetup = (BootSetup)tuple28._1();
        ListMap<String, ListMap<String, Option<String>>> listMap7 = tuple28._2();
        Tuple2 tuple29 = this.processSection(listMap7, "log", new $anonfun$5(this));
        if (tuple29 == null) {
            throw new MatchError(tuple29);
        }
        Tuple2 tuple210 = new Tuple2(tuple29._1(), tuple29._2());
        Logging logging = (Logging)tuple210._1();
        ListMap<String, ListMap<String, Option<String>>> listMap8 = tuple210._2();
        Tuple2 tuple211 = this.processSection(listMap8, "app-properties", new $anonfun$6(this));
        if (tuple211 == null) {
            throw new MatchError(tuple211);
        }
        Tuple2 tuple212 = new Tuple2(tuple211._1(), tuple211._2());
        List list4 = (List)tuple212._1();
        ListMap<String, ListMap<String, Option<String>>> listMap9 = tuple212._2();
        Tuple2 tuple213 = this.processSection(listMap9, "ivy", new $anonfun$7(this));
        if (tuple213 == null) {
            throw new MatchError(tuple213);
        }
        Tuple2 tuple214 = new Tuple2(tuple213._1(), tuple213._2());
        Option option = (Option)tuple214._1();
        ListMap<String, ListMap<String, Option<String>>> listMap10 = tuple214._2();
        this.check(listMap10, "section");
        String string = "";
        String string2 = "";
        Classifiers classifiers = new Classifiers(list.$colon$colon(string), list2.$colon$colon(string2));
        return new LaunchConfiguration(version2, new IvyOptions(option, classifiers, list3), application, bootSetup, logging, list4);
    }

    public final LaunchConfiguration xsbt$boot$ConfigurationParser$$apply(BufferedReader in$1) {
        return this.processSections(this.processLines(this.readLine$1(Nil$.MODULE$, 0, in$1)));
    }

    public LaunchConfiguration apply(Reader reader) {
        return (LaunchConfiguration)Using$.MODULE$.apply(new BufferedReader(reader), new $anonfun$apply$3(this));
    }
}

