/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import jline.Terminal;
import jline.UnixTerminal$1;
import jline.UnixTerminal$ReplayPrefixOneCharInputStream;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short O_PREFIX = 79;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    public static final short DEL_THIRD = 51;
    public static final short DEL_SECOND = 126;
    private boolean echoEnabled;
    private String ttyConfig;
    private boolean backspaceDeleteSwitched = false;
    private static String sttyCommand = System.getProperty("jline.sttyCommand", "stty");
    private String encoding = System.getProperty("input.encoding", "UTF-8");
    private UnixTerminal$ReplayPrefixOneCharInputStream replayStream = new UnixTerminal$ReplayPrefixOneCharInputStream(this.encoding);
    private InputStreamReader replayReader;

    public UnixTerminal() {
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void checkBackspace() {
        String[] stringArray = this.ttyConfig.split(":|=");
        if (stringArray.length < 7) {
            return;
        }
        if (stringArray[6] == null) {
            return;
        }
        this.backspaceDeleteSwitched = stringArray[6].equals("7f");
    }

    public void initializeTerminal() {
        this.ttyConfig = UnixTerminal.stty("-g");
        if (this.ttyConfig.length() == 0 || this.ttyConfig.indexOf("=") == -1 && this.ttyConfig.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + this.ttyConfig);
        }
        this.checkBackspace();
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        this.echoEnabled = false;
        try {
            Runtime.getRuntime().addShutdownHook(new UnixTerminal$1(this));
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            return;
        }
    }

    public void restoreTerminal() {
        if (this.ttyConfig != null) {
            UnixTerminal.stty(this.ttyConfig);
            this.ttyConfig = null;
        }
        UnixTerminal.resetTerminal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readVirtualKey(InputStream inputStream) {
        int n = this.readCharacter(inputStream);
        if (this.backspaceDeleteSwitched) {
            if (n == 127) {
                return 8;
            }
            if (n == 8) {
                return 127;
            }
        }
        if (n == 27) {
            while (n == 27) {
                n = this.readCharacter(inputStream);
            }
            if (n == 91 || n == 79) {
                n = this.readCharacter(inputStream);
                if (n == 65) {
                    return 16;
                }
                if (n == 66) {
                    return 14;
                }
                if (n == 68) {
                    return 2;
                }
                if (n == 67) {
                    return 6;
                }
                if (n == 72) {
                    return 1;
                }
                if (n == 70) {
                    return 5;
                }
                if (n == 51) {
                    this.readCharacter(inputStream);
                    return 127;
                }
            }
        }
        if (n <= 128) return n;
        InputStream inputStream2 = inputStream;
        int n2 = n;
        UnixTerminal$ReplayPrefixOneCharInputStream unixTerminal$ReplayPrefixOneCharInputStream = this.replayStream;
        this.replayStream.byteRead = 0;
        unixTerminal$ReplayPrefixOneCharInputStream.firstByte = (byte)n2;
        unixTerminal$ReplayPrefixOneCharInputStream.wrappedStream = inputStream2;
        unixTerminal$ReplayPrefixOneCharInputStream.byteLength = 1;
        if (unixTerminal$ReplayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-8")) {
            UnixTerminal$ReplayPrefixOneCharInputStream unixTerminal$ReplayPrefixOneCharInputStream2 = unixTerminal$ReplayPrefixOneCharInputStream;
            if ((unixTerminal$ReplayPrefixOneCharInputStream2.firstByte & 0xFFFFFFE0) == -64) {
                unixTerminal$ReplayPrefixOneCharInputStream2.byteLength = 2;
                return this.replayReader.read();
            } else if ((unixTerminal$ReplayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF0) == -32) {
                unixTerminal$ReplayPrefixOneCharInputStream2.byteLength = 3;
                return this.replayReader.read();
            } else {
                if ((unixTerminal$ReplayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF8) != -16) throw new IOException("invalid UTF-8 first byte: " + unixTerminal$ReplayPrefixOneCharInputStream2.firstByte);
                unixTerminal$ReplayPrefixOneCharInputStream2.byteLength = 4;
            }
            return this.replayReader.read();
        } else if (unixTerminal$ReplayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-16")) {
            unixTerminal$ReplayPrefixOneCharInputStream.byteLength = 2;
            return this.replayReader.read();
        } else {
            if (!unixTerminal$ReplayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-32")) return this.replayReader.read();
            unixTerminal$ReplayPrefixOneCharInputStream.byteLength = 4;
        }
        return this.replayReader.read();
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        int n = -1;
        try {
            n = UnixTerminal.getTerminalProperty("columns");
        }
        catch (Exception exception) {}
        if (n == -1) {
            n = 80;
        }
        return n;
    }

    public int getTerminalHeight() {
        int n = -1;
        try {
            n = UnixTerminal.getTerminalProperty("rows");
        }
        catch (Exception exception) {}
        if (n == -1) {
            n = 24;
        }
        return n;
    }

    private static int getTerminalProperty(String string) {
        String string2 = UnixTerminal.stty("-a");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith(string)) {
                int n = string3.lastIndexOf(" ");
                return Integer.parseInt(string3.substring(n).trim());
            }
            if (!string3.endsWith(string)) continue;
            int n = string3.indexOf(" ");
            return Integer.parseInt(string3.substring(0, n).trim());
        }
        return -1;
    }

    private static String stty(String string) {
        String string2 = "stty " + string + " < /dev/tty";
        return UnixTerminal.exec(new String[]{"sh", "-c", string2}).trim();
    }

    private static String exec(String[] stringArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process2 = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process2.getInputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream = process2.getErrorStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        process2.waitFor();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static void setSttyCommand(String string) {
        sttyCommand = string;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void enableEcho() {
        try {
            UnixTerminal.stty("echo");
            this.echoEnabled = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void disableEcho() {
        try {
            UnixTerminal.stty("-echo");
            this.echoEnabled = false;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

