/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;
import scala.collection.mutable.GrowingBuilder;

public final class ModuleRules {
    private Map rules = new LinkedHashMap();

    public ModuleRules() {
    }

    private ModuleRules(Map map2) {
        this.rules = new LinkedHashMap(map2);
    }

    public final void defineRule(MapMatcher mapMatcher, Object object) {
        GrowingBuilder.checkNotNull(mapMatcher, "condition");
        GrowingBuilder.checkNotNull(object, "rule");
        this.rules.put(mapMatcher, object);
    }

    public final Object getRule(ModuleId moduleId) {
        return this.getRule(moduleId, NoFilter.INSTANCE);
    }

    public final Object[] getRules(ModuleId moduleId) {
        Filter filter2 = NoFilter.INSTANCE;
        Map map2 = moduleId.getAttributes();
        ModuleRules moduleRules = this;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = moduleRules.rules.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Map.Entry entry = iterator.next();
            if (!((MapMatcher)entry.getKey()).matches(map2) || !filter2.accept(v = entry.getValue())) continue;
            arrayList.add(v);
        }
        return arrayList.toArray();
    }

    public final Object getRule(ModuleRevisionId moduleRevisionId) {
        return this.getRule(moduleRevisionId, NoFilter.INSTANCE);
    }

    public final Object getRule(ModuleId moduleId, Filter filter2) {
        GrowingBuilder.checkNotNull(moduleId, "mid");
        return this.getRule(moduleId.getAttributes(), filter2);
    }

    public final Object getRule(ModuleRevisionId moduleRevisionId, Filter filter2) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "mrid");
        GrowingBuilder.checkNotNull(filter2, "filter");
        Map map2 = moduleRevisionId.getAttributes();
        return this.getRule(map2, filter2);
    }

    private Object getRule(Map map2, Filter filter2) {
        Iterator iterator = this.rules.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Map.Entry entry = iterator.next();
            if (!((MapMatcher)entry.getKey()).matches(map2) || !filter2.accept(v = entry.getValue())) continue;
            return v;
        }
        return null;
    }

    public final void dump(String string) {
        if (this.rules.isEmpty()) {
            Message.debug(string + "NONE");
            return;
        }
        Iterator iterator = this.rules.keySet().iterator();
        while (iterator.hasNext()) {
            MapMatcher mapMatcher = (MapMatcher)iterator.next();
            Object v = this.rules.get(mapMatcher);
            Message.debug(string + mapMatcher + " -> " + v);
        }
    }

    public final Map getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public final Object clone() {
        return new ModuleRules(this.rules);
    }
}

