package jp.sf.amateras.cookiesession.primitive;

// TODO 他の型もサポートする
/**
 *
 *
 * @author Naoki Takezoe
 */
public class PrimitiveWrapperUtil {

	/**
	 * Wraps the wrapper object (or string) by the container to JSON encoding.
	 *
	 * @param value the value to convert to JSON
	 * @return the wrapped value if it's wrapper object or string, otherwise the raw value
	 */
	public static Object wrap(Object value){
		if(value instanceof Integer){
			return new IntegerContainer((Integer) value);
		} else if(value instanceof Long){
			return new LongContainer((Long) value);
		} else if(value instanceof String){
			return new StringContainer((String) value);
		}
		return value;
	}

	/**
	 * Retrieves the wrapped value from the container.
	 *
	 * @param value the container or any other object
	 * @return unwrapped value the unwrapped value if the given value is container, otherwise the raw value
	 */
	public static Object getValue(Object value){
		if(value instanceof IntegerContainer){
			return ((IntegerContainer) value).value;
		} else if(value instanceof LongContainer){
			return ((LongContainer) value).value;
		} else if(value instanceof StringContainer){
			return ((StringContainer) value).value;
		}
		return value;
	}

}
