package jp.sf.amateras.mirage.dialect;

import java.util.List;

import jp.sf.amateras.mirage.type.PostgreResultSetValueType;
import jp.sf.amateras.mirage.type.ValueType;

public class PostgreDialect extends StandardDialect {

	private PostgreResultSetValueType valueType = new PostgreResultSetValueType();

    @Override
    public String getName() {
        return "postgre";
    }

    @Override
    public boolean needsParameterForResultSet() {
        return true;
    }

    @Override
    protected ValueType getValueTypeInternal(Class<?> clazz, List<ValueType> valueTypes){
        if (List.class.isAssignableFrom(clazz)) {
            return valueType;
        }
        return null;
    }
}
