/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import jline.Terminal;
import jline.WindowsTerminal$1;
import jline.WindowsTerminal$ReplayPrefixOneCharInputStream;

public class WindowsTerminal
extends Terminal {
    public static final int SPECIAL_KEY_INDICATOR = 224;
    public static final int NUMPAD_KEY_INDICATOR = 0;
    public static final int LEFT_ARROW_KEY = 75;
    public static final int RIGHT_ARROW_KEY = 77;
    public static final int UP_ARROW_KEY = 72;
    public static final int DOWN_ARROW_KEY = 80;
    public static final int DELETE_KEY = 83;
    public static final int HOME_KEY = 71;
    public static final char END_KEY = 'O';
    public static final char PAGE_UP_KEY = 'I';
    public static final char PAGE_DOWN_KEY = 'Q';
    public static final char INSERT_KEY = 'R';
    public static final char ESCAPE_KEY = '\u0000';
    private Boolean directConsole;
    private boolean echoEnabled;
    private String encoding = System.getProperty("jline.WindowsTerminal.input.encoding", System.getProperty("file.encoding"));
    private WindowsTerminal$ReplayPrefixOneCharInputStream replayStream = new WindowsTerminal$ReplayPrefixOneCharInputStream(this.encoding);
    private InputStreamReader replayReader;

    public WindowsTerminal() {
        String string = System.getProperty("jline.WindowsTerminal.directConsole");
        if ("true".equals(string)) {
            this.directConsole = Boolean.TRUE;
        } else if ("false".equals(string)) {
            this.directConsole = Boolean.FALSE;
        }
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private native int getConsoleMode();

    private native void setConsoleMode(int var1);

    private native int readByte();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    public int readCharacter(InputStream inputStream) {
        if (this.directConsole == Boolean.FALSE) {
            return super.readCharacter(inputStream);
        }
        if (this.directConsole == Boolean.TRUE || inputStream == System.in || inputStream instanceof FileInputStream && ((FileInputStream)inputStream).getFD() == FileDescriptor.in) {
            return this.readByte();
        }
        return super.readCharacter(inputStream);
    }

    public void initializeTerminal() {
        File file2;
        block7: {
            String string = "jline";
            WindowsTerminal windowsTerminal = this;
            String string2 = windowsTerminal.getClass().getPackage().getImplementationVersion();
            if (string2 == null) {
                string2 = "";
            }
            string2 = string2.replace('.', '_');
            file2 = new File(System.getProperty("java.io.tmpdir"), string + "_" + string2 + ".dll");
            boolean bl = file2.isFile();
            int n = 32;
            if (System.getProperty("os.arch").indexOf("64") != -1) {
                n = 64;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(windowsTerminal.getClass().getResourceAsStream(string + n + ".dll"));
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[10240];
                int n2 = 0;
                while (n2 != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                    n2 = ((InputStream)bufferedInputStream).read(byArray);
                }
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                if (bl) break block7;
                throw iOException;
            }
        }
        file2.deleteOnExit();
        System.load(file2.getAbsolutePath());
        int n = this.getConsoleMode();
        this.setConsoleMode(n & 0xFFFFFFFB);
        int n3 = n & 0xFFFFFFF0;
        this.echoEnabled = false;
        this.setConsoleMode(n3);
        try {
            Runtime.getRuntime().addShutdownHook(new WindowsTerminal$1(this, n));
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readVirtualKey(InputStream inputStream) {
        int n = this.readCharacter(inputStream);
        if (n == 224 || n == 0) {
            switch (this.readCharacter(inputStream)) {
                case 72: {
                    return 16;
                }
                case 75: {
                    return 2;
                }
                case 77: {
                    return 6;
                }
                case 80: {
                    return 14;
                }
                case 83: {
                    return 127;
                }
                case 71: {
                    return 1;
                }
                case 79: {
                    return 5;
                }
                case 73: {
                    return 11;
                }
                case 81: {
                    return 12;
                }
                case 0: {
                    return 27;
                }
                case 82: {
                    return 3;
                }
            }
            return 0;
        }
        if (n <= 128) return n;
        InputStream inputStream2 = inputStream;
        WindowsTerminal$ReplayPrefixOneCharInputStream windowsTerminal$ReplayPrefixOneCharInputStream = this.replayStream;
        this.replayStream.byteRead = 0;
        windowsTerminal$ReplayPrefixOneCharInputStream.firstByte = (byte)n;
        windowsTerminal$ReplayPrefixOneCharInputStream.wrappedStream = inputStream2;
        windowsTerminal$ReplayPrefixOneCharInputStream.byteLength = 1;
        if (windowsTerminal$ReplayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-8")) {
            WindowsTerminal$ReplayPrefixOneCharInputStream windowsTerminal$ReplayPrefixOneCharInputStream2 = windowsTerminal$ReplayPrefixOneCharInputStream;
            if ((windowsTerminal$ReplayPrefixOneCharInputStream2.firstByte & 0xFFFFFFE0) == -64) {
                windowsTerminal$ReplayPrefixOneCharInputStream2.byteLength = 2;
                return this.replayReader.read();
            } else if ((windowsTerminal$ReplayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF0) == -32) {
                windowsTerminal$ReplayPrefixOneCharInputStream2.byteLength = 3;
                return this.replayReader.read();
            } else {
                if ((windowsTerminal$ReplayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF8) != -16) throw new IOException("invalid UTF-8 first byte: " + windowsTerminal$ReplayPrefixOneCharInputStream2.firstByte);
                windowsTerminal$ReplayPrefixOneCharInputStream2.byteLength = 4;
            }
            return this.replayReader.read();
        } else if (windowsTerminal$ReplayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-16")) {
            windowsTerminal$ReplayPrefixOneCharInputStream.byteLength = 2;
            return this.replayReader.read();
        } else {
            if (!windowsTerminal$ReplayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-32")) return this.replayReader.read();
            windowsTerminal$ReplayPrefixOneCharInputStream.byteLength = 4;
        }
        return this.replayReader.read();
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isANSISupported() {
        return false;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        return this.getWindowsTerminalWidth();
    }

    public int getTerminalHeight() {
        return this.getWindowsTerminalHeight();
    }

    public void setDirectConsole(Boolean bl) {
        this.directConsole = bl;
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void enableEcho() {
        this.setConsoleMode(this.getConsoleMode() | 4 | 2 | 1 | 8);
        this.echoEnabled = true;
    }

    public synchronized void disableEcho() {
        this.setConsoleMode(this.getConsoleMode() & 0xFFFFFFF0);
        this.echoEnabled = true;
    }

    public InputStream getDefaultBindings() {
        return this.getClass().getResourceAsStream("windowsbindings.properties");
    }

    static void access$000(WindowsTerminal windowsTerminal, int n) {
        windowsTerminal.setConsoleMode(n);
    }
}

