/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class History {
    private List history = new ArrayList();
    private PrintWriter output = null;
    private int maxSize = 500;
    private int currentIndex = 0;

    public History() {
    }

    public History(File file2) {
        this.setHistoryFile(file2);
    }

    public void setHistoryFile(File file2) {
        if (file2.isFile()) {
            this.load(new FileInputStream(file2));
        }
        this.setOutput(new PrintWriter((Writer)new FileWriter(file2), true));
        this.flushBuffer();
    }

    public void load(InputStream inputStream) {
        this.load(new InputStreamReader(inputStream));
    }

    public void load(Reader reader) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.addToHistory((String)iterator.next());
        }
    }

    public int size() {
        return this.history.size();
    }

    public void clear() {
        this.history.clear();
        this.currentIndex = 0;
    }

    public void addToHistory(String string) {
        if (this.history.size() != 0 && string.equals(this.history.get(this.history.size() - 1))) {
            return;
        }
        this.history.add(string);
        while (this.history.size() > this.getMaxSize()) {
            this.history.remove(0);
        }
        this.currentIndex = this.history.size();
        if (this.getOutput() != null) {
            this.getOutput().println(string);
            this.getOutput().flush();
        }
    }

    public void flushBuffer() {
        if (this.getOutput() != null) {
            Iterator iterator = this.history.iterator();
            while (iterator.hasNext()) {
                this.getOutput().println((String)iterator.next());
            }
            this.getOutput().flush();
        }
    }

    public boolean moveToLastEntry() {
        int n = this.history.size() - 1;
        if (n >= 0 && n != this.currentIndex) {
            this.currentIndex = this.history.size() - 1;
            return true;
        }
        return false;
    }

    public void moveToEnd() {
        this.currentIndex = this.history.size();
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setOutput(PrintWriter printWriter) {
        this.output = printWriter;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public String current() {
        if (this.currentIndex >= this.history.size()) {
            return "";
        }
        return (String)this.history.get(this.currentIndex);
    }

    public boolean previous() {
        if (this.currentIndex <= 0) {
            return false;
        }
        --this.currentIndex;
        return true;
    }

    public boolean next() {
        if (this.currentIndex >= this.history.size()) {
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    public List getHistoryList() {
        return Collections.unmodifiableList(this.history);
    }

    public String toString() {
        return this.history.toString();
    }

    public boolean moveToFirstEntry() {
        if (this.history.size() > 0 && this.currentIndex != 0) {
            this.currentIndex = 0;
            return true;
        }
        return false;
    }
}

