/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater$UpdaterHandler;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.InputSource;

public final class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    private XmlModuleDescriptorUpdater() {
    }

    public static void update(InputStream inputStream, Resource resource, File file2, UpdateOptions updateOptions) {
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            URL uRL = null;
            if (resource instanceof URLResource) {
                uRL = ((URLResource)resource).getURL();
            } else if (resource instanceof FileResource) {
                uRL = ((FileResource)resource).getFile().toURI().toURL();
            }
            UpdateOptions updateOptions2 = updateOptions;
            FileOutputStream fileOutputStream2 = fileOutputStream;
            InputStream inputStream2 = inputStream;
            URL uRL2 = uRL;
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream2, "UTF-8"));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
            bufferedInputStream.mark(10000);
            XmlModuleDescriptorUpdater.copyHeader(bufferedInputStream, printWriter);
            bufferedInputStream.reset();
            try {
                XmlModuleDescriptorUpdater$UpdaterHandler xmlModuleDescriptorUpdater$UpdaterHandler = new XmlModuleDescriptorUpdater$UpdaterHandler(uRL2, printWriter, updateOptions2);
                InputSource inputSource = new InputSource(bufferedInputStream);
                if (uRL2 != null) {
                    inputSource.setSystemId(uRL2.toExternalForm());
                }
                XMLHelper.parse(inputSource, null, xmlModuleDescriptorUpdater$UpdaterHandler, xmlModuleDescriptorUpdater$UpdaterHandler);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                IllegalStateException illegalStateException = new IllegalStateException("impossible to update Ivy files: parser problem");
                illegalStateException.initCause(parserConfigurationException);
                throw illegalStateException;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            Message.warn("failed to close a stream : " + iOException.toString());
        }
        try {
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (IOException iOException) {
            Message.warn("failed to close a stream : " + iOException.toString());
            return;
        }
    }

    private static void copyHeader(InputStream inputStream, PrintWriter printWriter) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string != null && string.startsWith("<?xml ")) {
            printWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            string = string.substring(string.indexOf(">") + 1, string.length());
        }
        while (string != null) {
            int n = string.indexOf("<ivy-module");
            if (n != -1) {
                printWriter.write(string.substring(0, n));
                return;
            }
            printWriter.write(string);
            printWriter.write(LINE_SEPARATOR);
            string = bufferedReader.readLine();
        }
    }
}

