/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectMemory;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.RandomUtils;

public class FileSystemMemory
extends FileSystem {
    private static final FileSystemMemory INSTANCE = new FileSystemMemory();
    private static final HashMap MEMORY_FILES = new HashMap();

    public static FileSystemMemory getInstance() {
        return INSTANCE;
    }

    private FileSystemMemory() {
    }

    public long length(String fileName) {
        return this.getMemoryFile(fileName).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldName, String newName) throws SQLException {
        FileObjectMemory f = this.getMemoryFile(oldName);
        f.setName(newName);
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            MEMORY_FILES.remove(oldName);
            MEMORY_FILES.put(newName, f);
        }
    }

    public boolean createNewFile(String fileName) throws SQLException {
        if (this.exists(fileName)) {
            return false;
        }
        this.getMemoryFile(fileName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String fileName) {
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            return MEMORY_FILES.get(fileName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String fileName) throws SQLException {
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            MEMORY_FILES.remove(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryDelete(String fileName) {
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            MEMORY_FILES.remove(fileName);
        }
        return true;
    }

    public String createTempFile(String name, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        name = name + ".";
        int i = 0;
        while (true) {
            String n;
            if (!this.exists(n = name + Math.abs(RandomUtils.getSecureLong()) + suffix)) {
                this.getMemoryFile(n);
                return n;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listFiles(String path) throws SQLException {
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            String[] list = new String[MEMORY_FILES.size()];
            FileObjectMemory[] l = new FileObjectMemory[MEMORY_FILES.size()];
            MEMORY_FILES.values().toArray(l);
            for (int i = 0; i < list.length; ++i) {
                list[i] = l[i].getName();
            }
            return list;
        }
    }

    public void deleteRecursive(String fileName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean isReadOnly(String fileName) {
        return false;
    }

    public String normalize(String fileName) throws SQLException {
        return fileName;
    }

    public String getParent(String fileName) {
        int idx = Math.max(fileName.indexOf(58), fileName.lastIndexOf(47));
        return fileName.substring(0, idx);
    }

    public boolean isDirectory(String fileName) {
        return false;
    }

    public boolean isAbsolute(String fileName) {
        return true;
    }

    public String getAbsolutePath(String fileName) {
        return fileName;
    }

    public long getLastModified(String fileName) {
        return this.getMemoryFile(fileName).getLastModified();
    }

    public boolean canWrite(String fileName) {
        return true;
    }

    public void copy(String original, String copy) throws SQLException {
        try {
            OutputStream out = this.openFileOutputStream(copy, false);
            InputStream in = this.openFileInputStream(original);
            IOUtils.copyAndClose(in, out);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, "Can not copy " + original + " to " + copy);
        }
    }

    public void createDirs(String fileName) throws SQLException {
    }

    public String getFileName(String name) throws SQLException {
        return name;
    }

    public boolean fileStartsWith(String fileName, String prefix) {
        return fileName.startsWith(prefix);
    }

    public OutputStream openFileOutputStream(String fileName, boolean append) throws SQLException {
        try {
            FileObjectMemory obj = this.getMemoryFile(fileName);
            obj.seek(0L);
            return new FileObjectOutputStream(obj, append);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, fileName);
        }
    }

    public InputStream openFileInputStream(String fileName) throws IOException {
        FileObjectMemory obj = this.getMemoryFile(fileName);
        obj.seek(0L);
        return new FileObjectInputStream(obj);
    }

    public FileObject openFileObject(String fileName, String mode) throws IOException {
        FileObjectMemory obj = this.getMemoryFile(fileName);
        obj.seek(0L);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObjectMemory getMemoryFile(String fileName) {
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            FileObjectMemory m = (FileObjectMemory)MEMORY_FILES.get(fileName);
            if (m == null) {
                boolean compress = fileName.startsWith("memLZF:");
                m = new FileObjectMemory(fileName, compress);
                MEMORY_FILES.put(fileName, m);
            }
            return m;
        }
    }
}

