package jp.sf.amateras.functions.utils;

import static org.mockito.Mockito.when;

import javax.servlet.http.HttpServletResponse;

import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import junit.framework.TestCase;

public class ResponseUtilsTest extends TestCase {
	
	@Mock
	private HttpServletResponse response;
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		MockitoAnnotations.initMocks(this);
	}
	
	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		ResponseUtils.removeResponse();
	}
	
	public void testSetResponse() {
		assertNull(ResponseUtils.getResponse());
		
		ResponseUtils.setResponse(response);
		assertNotNull(ResponseUtils.getResponse());
		assertSame(response, ResponseUtils.getResponse());
	}

	public void testGetEncoding() {
		when(response.getCharacterEncoding()).thenReturn("Windows-31J");
		ResponseUtils.setResponse(response);
		assertEquals("Windows-31J", ResponseUtils.getEncoding());
	}

	public void testRemoveResponse() {
		ResponseUtils.setResponse(response);
		assertNotNull(ResponseUtils.getResponse());
		
		ResponseUtils.removeResponse();
		assertNull(ResponseUtils.getResponse());
	}

}
