package jp.sf.amateras.mirage.scala

/**
 * Provides utility methods used by mirage-scala.
 */
object Utilities {

  def using[A, B <: {def close(): Unit}] (closeable: B) (f: B => A): A =
    try {
      f(closeable)
    } finally {
      if(closeable != null){
        withoutException { closeable.close() }
      }
    }

  /**
   * Runs the given function without any exceptions.
   */
  def withoutException(func: => Unit): Unit = {
    try {
      func
    } catch {
      case ex: Exception => {}
    }
  }
}