package jp.sf.amateras.mirage.example.page;

import static jp.sf.amateras.mirage.test.MirageTestContext.*;
import static org.junit.Assert.*;

import java.util.Date;

import jp.sf.amateras.mirage.example.entity.Book;
import jp.sf.amateras.mirage.example.page.BookListPage.BookSearchParam;

import org.apache.click.Context;
import org.apache.click.MockContext;
import org.junit.Test;

public class BookRegisterPageTest extends AbstractPageTest<BookRegisterPage> {

	@Test
	public void testOnInit() {
		MockContext context = (MockContext) Context.getThreadLocalContext();
		context.setSessionAttribute(BookSearchParam.class.getName(), new BookSearchParam());

		page.onInit();

		assertFalse(context.hasSessionAttribute(BookSearchParam.class.getName()));
		assertEquals(page.getMessage("title.bookRegister"), page.getModel().get("title"));
	}

	@Test
	public void testDoRegister() {
		Book book = new Book();
		book.setName("Mirage in Action");
		book.setAuthor("Naoki Takezoe");
		book.setPublisher("BPress");
		book.setPrice(100);
		book.setPublishDate(new Date());

		page.onInit();

		page.name.setValueObject(book.getName());
		page.author.setValueObject(book.getAuthor());
		page.price.setValueObject(book.getPrice());
		page.publisher.setValueObject(book.getPublisher());
		page.publishDate.setValueObject(book.getPublishDate());

		boolean result = page.doRegister();

		assertFalse(result);

		verifySqlNumber(1);
		verifyInsertSql(0, book);
	}

	@Test
	public void testDoRegister_Invalid() {
		page.onInit();
		page.form.setError("error");

		boolean result = page.doRegister();

		assertTrue(result);
		verifySqlNumber(0);
	}
}
