package jp.sf.amateras.rdiffbackup.dto;

import jp.sf.amateras.rdiffbackup.action.BrowseAction;

import org.seasar.struts.util.RequestUtil;

/**
 * 変更履歴の変更情報を格納するDTOです。
 *
 * @see BrowseAction
 * @author Naoki Takezoe
 */
public class ChangeDto {

	/**
	 * 変更種別（new|changed|deleted）
	 */
	public String type;

	/**
	 * バックアップディレクトリ内のパス
	 */
	public String path;

	/**
	 * アイコンのパスを取得します。
	 *
	 * @return 変更種別に応じたアイコンのパス
	 */
	public String getIcon(){
		String path = RequestUtil.getRequest().getContextPath();

		if(type.equals("new")){
			return path + "/images/add.png";

		} else if(type.equals("changed")){
			return path + "/images/pencil.png";

		} else if(type.equals("deleted")){
			return path + "/images/cancel.png";

		}
		return "";
	}

}
