package org.seasar.s2jdbcmock;

import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AutoDeleteImpl;

public class MockAutoDelete<T> extends AutoDeleteImpl<T> {

	public MockAutoDelete(JdbcManagerImplementor jdbcManager, T entity) {
		super(jdbcManager, entity);
	}

	@Override
    protected int executeInternal() {
        try {
            logSql();

            ExecutedSQLInfo executedSqlInfo = new ExecutedSQLInfo(executedSql, getParamValues());
            MockResultContext.addExecutedSql(executedSqlInfo);

            Integer rows = MockResultContext.getNextResult(Integer.class);
            if(rows == null){
            	rows = 1;
            }
            if (isOptimisticLock()) {
                validateRows(rows);
            }
            if (entityMeta.hasVersionPropertyMeta()) {
                incrementVersion();
            }
            return rows;
        } finally {
        }
    }
}
