package org.seasar.s2jdbcmock.service;

import javax.annotation.Resource;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.s2jdbcmock.entity.Employee;

public class SampleService {

	@Resource
	protected JdbcManager jdbcManager;

	public Employee getEmployee(Integer empId){
		return jdbcManager.from(Employee.class).id(empId).getSingleResult();
	}

	public void insert(Employee employee){
		jdbcManager.insert(employee).execute();
	}

	public void update(Employee employee){
		jdbcManager.update(employee).execute();
	}

	public void delete(Integer empId){
		Employee employee = new Employee();
		employee.empId = empId;
		jdbcManager.delete(employee).execute();
	}

}
