package org.seasar.s2jdbcmock.service;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.seasar.framework.unit.Seasar2;
import org.seasar.s2jdbcmock.MockResultContext;
import org.seasar.s2jdbcmock.entity.Employee;

@RunWith(Seasar2.class)
public class SampleServiceTest {

	protected SampleService sampleService;

	@Before
	public void init(){
		MockResultContext.reset();
	}

	@Test
	public void testGetEmployeeTx(){
		sampleService.getEmployee(1);
		MockResultContext.verifySqlByRegExp(0, "SELECT .* FROM EMPLOYEE .* WHERE .*EMP_ID = \\?", 1);
	}

	@Test
	public void testInsertTx(){
		Employee employee = new Employee();
		employee.name = "Naoki Takezoe";
		sampleService.insert(employee);
		MockResultContext.verifySqlByRegExp(0, "INSERT INTO EMPLOYEE .*", null, "Naoki Takezoe");
	}

	@Test
	public void testUpdateTx(){
		Employee employee = new Employee();
		employee.empId = 1;
		employee.name = "Naoki Takezoe";
		sampleService.update(employee);
		MockResultContext.verifySqlByRegExp(0, "UPDATE EMPLOYEE .* WHERE .*EMP_ID = \\?", "Naoki Takezoe", 1);
	}

	@Test
	public void testDeleteTx(){
		sampleService.delete(1);
		MockResultContext.verifySql(0, "DELETE FROM EMPLOYEE WHERE EMP_ID = ?", 1);
	}
}
