# -*- coding: utf-8 -*-

# お守りIdとスキルIdペアの保持用クラス
# 2013/12/16 written by kei9 

import db_supports

class AmuletIdSkillIdHolder(object):
    u""" お守りのスキルを保持するクラス """
    def __init__(self, amulet_id_list, skill_id_list):
        u""" skill_id_list: list of skill id
            if skill is unknown, element must be None
        """
        self.skill_id_list = list(skill_id_list)
        self.amulet_id_list = list(amulet_id_list)

    def is_empty(self):
        u""" すべての要素がNoneのときTrueを返す """
        if all([x is None for x in self.skill_id_list]) and all([x is None for x in self.amulet_id_list]):
            return True
        else:
            return False

    def get_where_and_sql(self, remove_where=False):
        u""" SQLのWhere文に変換する(AND結合) """
        if self.is_empty() is False:
            valid_eqls = []
            for skill_col, amulet_col, skill_id, amu_id in zip(
                    db_supports.SEED1_TENUN_COL_SKILL1_LIST,
                    db_supports.SEED1_TENUN_COL_AMULET_LIST,
                    self.skill_id_list, self.amulet_id_list):
                if skill_id is not None and amu_id is not None:
                    valid_eqls.append(u"{col}={skill_id}".format(col=skill_col, skill_id=skill_id))
                    valid_eqls.append(u"{col}={amu_id}".format(col=amulet_col, amu_id=amu_id))
            if remove_where:
                return u" and ".join(valid_eqls)
            else:
                return u" where " + u" and ".join(valid_eqls)
        else:
            return ""

