# -*- coding: utf-8 -*-

# sufficient valueを保持するクラス
# 2013/12/08 written by kei9 

import db_supports

class SufficientsHolder(object):
    u""" 充足値を保持するクラス """
    def __init__(self, sufficient_list):
        u""" sufficient_list: list of sufficient
        """
        self.sufficient_set = set(sufficient_list)

    def get_where_in_sql(self, remove_where=False):
        u""" SQLのWhere文に変換する(IN句) """
        if len(self.sufficient_set) >= 1:
            uni_list = [u"{0}".format(x) for x in self.sufficient_set]
            sql = u" {col} IN({in_phrase})".format(
                    col=db_supports.SUFFICIENT_COL_SUFFICIENT_VALUE,
                    in_phrase=u",".join(uni_list))

            if remove_where:
                return sql
            else:
                return u" where" + sql
        else:
            return ""


