# -*- coding: utf-8 -*-

# GUIのメインフレームにおける流れ説明Notebookのview
# 2013/12/15 written by kei9

import wx
from wx import xrc

import constnumbers

class NoteBookFlowView():
    u""" メインフレームの流れ説明タブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()

    def _init_view(self):
        # initialize view
        self.text_ctrl_flow = xrc.XRCCTRL(self.frame, "TextCtrlFlow")
        self.text_ctrl_seed = xrc.XRCCTRL(self.frame, "TextCtrlSeedExplanation")
        self.text_ctrl_flow.SetValue(constnumbers.SECOND_SKILL_FLOW)
        self.text_ctrl_seed.SetValue(constnumbers.SEED_EXPLANATION)

    def set_flow_value(self, value):
        self.text_ctrl_flow.SetValue(value)

    def clear_flow_value(self):
        self.text_ctrl_flow.SetValue(u"")
