# -*- coding: utf-8 -*-

# GUIのメインフレームにおけるSeed2特定Notebookのview
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers

class NoteBookSeed2View():
    u""" メインのフレームのSeed2特定タブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()

    def _init_view(self):
        # initialize view

        # buttons
        self.button_search = xrc.XRCCTRL(self.frame, "ButtonSeedSearch")
        self.button_clear = xrc.XRCCTRL(self.frame, "ButtonSeedClear")
        self.button_skill2 = xrc.XRCCTRL(self.frame, "ButtonSkillFromSeedSearch")

        self.ID_BUTTON_SEARCH = xrc.XRCID("ButtonSeedSearch")
        self.ID_BUTTON_CLEAR = xrc.XRCID("ButtonSeedClear")
        self.ID_BUTTON_SKILL2 = xrc.XRCID("ButtonSkillFromSeedSearch")

        # text ctrl
        self.text_ctrl_seed2_explain = xrc.XRCCTRL(self.frame, "TextCtrlSeed2Explain")
        self.text_ctrl_seed2_result = xrc.XRCCTRL(self.frame, "TextCtrlSeedResults")

        # load combo boxes
        self.combo_box_skill_dict = {}
        self.combo_box_skill_dict[constnumbers.KEY_AMULET1] = [
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_1"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_2"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_3"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_4"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_5"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_6"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet1_7")]
        self.combo_box_skill_dict[constnumbers.KEY_AMULET2] = [
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_1"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_2"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_3"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_4"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_5"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_6"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet2_7")]
        self.combo_box_skill_dict[constnumbers.KEY_AMULET3] = [
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_1"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_2"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_3"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_4"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_5"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_6"),
                xrc.XRCCTRL(self.frame, "ComboBoxAmulet3_7")]

        # load list box
        self.list_box_seed = xrc.XRCCTRL(self.frame, "ListBoxSeed")
        self.ID_LIST_BOX_SEED = xrc.XRCID("ListBoxSeed")

        # set explanation text
        self.text_ctrl_seed2_explain.SetValue(constnumbers.SEED_DECISION_EXPLANATION)

    def bind_button_search(self, event_func, evt=wx.EVT_BUTTON):
        u""" 検索ボタンへのイベント登録 """
        self.button_search.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンへのイベント登録 """
        self.button_clear.Bind(evt, event_func)

    def bind_button_skill2(self, event_func, evt=wx.EVT_BUTTON):
        u""" 対応スキル2ボタンへのイベント登録 """
        self.button_skill2.Bind(evt, event_func)

    def set_skill_names(self, amulet_key, skill_names):
        u""" キーに対応するComboboxにスキル名をセットする。"""
        for combo in self.combo_box_skill_dict[amulet_key]:
            combo.SetItems(skill_names)
            combo.SetSelection(0)

    def get_selected_skill_names(self, amulet_key):
        u""" キーに対応するComboboxで選択されているスキル名を返す"""
        return [combo.GetStringSelection() for combo in self.combo_box_skill_dict[amulet_key]]

    def set_skill_selected_idx(self, idx=0):
        u""" Comboboxの選択されたインデックスを全て指定された値とする """
        for key, combo_list in self.combo_box_skill_dict.items():
            for combo in combo_list:
                combo.SetSelection(idx)

    def set_seed_lists(self, seed_list):
        u""" Seed2一覧をセットする """
        self.list_box_seed.SetItems(seed_list)
        self.list_box_seed.SetSelection(0)

    def clear_seed_list(self):
        u""" Seed2一覧をクリアする """
        self.list_box_seed.Clear()

    def set_result_text(self, value):
        u""" 検索結果を示すTextCtrlへの値のセット """
        self.text_ctrl_seed2_result.SetValue(value)

    def set_skill2_button_enable(self, value):
        u""" 対応スキル検索ボタンの有効・無効の切り替え """
        if value is True:
            self.button_skill2.Enable()
        else:
            self.button_skill2.Disable()

    def get_selected_seed2(self):
        u""" ListBoxから選択したSeed2を返す。値が不正な場合はNoneを返す """
        seed = self.list_box_seed.GetStringSelection()
        if seed.isdigit():
            return int(seed)
        else:
            return None
