# -*- coding: utf-8 -*-

# GUIのメインフレームにおける設定Notebookのview
# 2013/12/15 written by kei9

import wx
from wx import xrc

import constnumbers

class NoteBookSettingView():
    u""" メインフレームの流れ説明タブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()

    def _init_view(self):
        # initialize view
        self.spin_ctrl_highlight1 = xrc.XRCCTRL(self.frame, "SpinCtrlHighlightThreshold1")
        self.spin_ctrl_highlight2 = xrc.XRCCTRL(self.frame, "SpinCtrlHighlightThreshold2")
        self.check_list_box_highlight_skill =  xrc.XRCCTRL(self.frame, "CheckListBoxHighlight")
        self.ID_CHECK_LIST_BOX_HIGHLIGHT_SKILL = xrc.XRCID("CheckListBoxHighlight")

        self.button_ok = xrc.XRCCTRL(self.frame, "ButtonSettingOK")
        self.button_clear = xrc.XRCCTRL(self.frame, "ButtonSettingClear")
        self.ID_BUTTON_OK = xrc.XRCID("ButtonSettingOK")
        self.ID_BUTTON_CLEAR = xrc.XRCID("ButtonSettingClear")

        # set min & max
        self.set_minmax(constnumbers.THRESHOLD1_MIN, constnumbers.THRESHOLD1_MAX,
                constnumbers.THRESHOLD2_MIN, constnumbers.THRESHOLD2_MAX)
        self.set_threshold(constnumbers.HIGHLIGHT_THRESHOLD1, constnumbers.HIGHLIGHT_THRESHOLD2)

    def set_minmax(self, threshold1_min, threshold1_max, threshold2_min, threshold2_max):
        u"""ハイライトする判定値のSpinCtrlの最大、最小値をセットする
            arg: (threshold1_min, threshold1_max, threshold2_min, threshold2_max)
        """
        self.spin_ctrl_highlight1.SetRange(threshold1_min, threshold1_max)
        self.spin_ctrl_highlight2.SetRange(threshold2_min, threshold2_max)

    def set_threshold(self, threshold1, threshold2):
        u"""ハイライトする判定値のSpinCtrlの値をセットする
            arg (threshold1, threshold2)
        """
        self.spin_ctrl_highlight1.SetValue(threshold1)
        self.spin_ctrl_highlight2.SetValue(threshold2)

    def get_threshold(self):
        u"""ハイライトする判定値のSpinCtrlの値を得る
            return (threshold1, threshold2)
        """
        threshold1 = self.spin_ctrl_highlight1.GetValue()
        threshold2 = self.spin_ctrl_highlight2.GetValue()
        return (threshold1, threshold2)

    def get_minmax(self):
        u"""ハイライトする判定値のSpinCtrlの最大、最小値を得る
            return (threshold1_min, threshold1_max, threshold2_min, threshold2_max)
        """
        threshold1_min = self.spin_ctrl_highlight1.GetMin()
        threshold1_max = self.spin_ctrl_highlight1.GetMax()
        threshold2_min = self.spin_ctrl_highlight2.GetMin()
        threshold2_max = self.spin_ctrl_highlight2.GetMax()
        return (threshold1_min, threshold1_max, threshold2_min, threshold2_max)

    def set_skill_strings(self, string_list):
        u""" CheckBoxListにスキル名をセットする """
        self.check_list_box_highlight_skill.SetItems(string_list)

    def get_checked_strings(self):
        u""" CheckBoxListでチェックの入った文字列のリストを返す """
        return [x for x in self.check_list_box_highlight_skill.GetCheckedStrings()]

    def set_checked_strings(self, string_list):
        u""" CheckBoxListで与えられた文字列に一致する名称のスキルにチェックを入れる """
        self.check_list_box_highlight_skill.SetCheckedStrings(string_list)

    def clear_checked_strings(self):
        u""" CheckBoxListのチェックを全て外す """
        for idx in self.check_list_box_highlight_skill.GetChecked():
            self.check_list_box_highlight_skill.Check(idx, False)

    def bind_button_ok(self, event_func, evt=wx.EVT_BUTTON):
        u""" OKボタンが押された時のイベントをセットする """
        self.button_ok.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンが押された時のイベントをセットする """
        self.button_clear.Bind(evt, event_func)
