TARGET_ARCH := x86
DISABLE_DEXPREOPT := true
TARGET_COMPRESS_MODULE_SYMBOLS := false
TARGET_PRELINK_MODULE := false
USE_CAMERA_STUB := true
TARGET_CPU_ABI := x86
TARGET_USERIMAGES_USE_EXT4 := true
TARGET_BOOTIMAGE_USE_EXT2 := true

TARGET_USE_DISKINSTALLER := false
TARGET_DISK_LAYOUT_CONFIG := $(SRC_TARGET_DIR)/board/generic_x86/disk_layout.conf
BOARD_BOOTIMAGE_MAX_SIZE := 8388608
BOARD_SYSLOADER_MAX_SIZE := 7340032
BOARD_FLASH_BLOCK_SIZE := 512
BOARD_USERDATAIMAGE_PARTITION_SIZE := 50M
BOARD_INSTALLERIMAGE_PARTITION_SIZE := 500M
TARGET_USERIMAGES_SPARSE_EXT_DISABLED := true

# the following variables could be overridden
TARGET_NO_BOOTLOADER ?= true
TARGET_NO_RECOVERY ?= true
TARGET_PROVIDES_INIT_RC ?= true
TARGET_HAS_THIRD_PARTY_APPS ?= false

# Set /system/bin/sh to mksh
TARGET_SHELL := mksh

USE_CUSTOM_RUNTIME_HEAP_MAX ?= "128M"

BOARD_USES_GENERIC_AUDIO ?= false
BOARD_USES_ALSA_AUDIO ?= true
BUILD_WITH_ALSA_UTILS ?= true
BOARD_HAVE_BLUETOOTH ?= true
# Set to true if you have touch screen
BOARD_USES_TSLIB ?= true
# This enables the wpa wireless driver
BOARD_WPA_SUPPLICANT_DRIVER ?= AWEXT
WPA_SUPPLICANT_VERSION ?= VER_0_6_X

ifneq ($(strip $(BOARD_GPU_DRIVERS)),)
TARGET_HARDWARE_3D := true
BOARD_EGL_CFG ?= device/common/gpu/egl_mesa.cfg
endif

BOARD_KERNEL_CMDLINE := root=/dev/ram0 androidboot_hardware=$(TARGET_PRODUCT) acpi_sleep=s3_bios,s3_mode $(if $(BOARD_GPU_DRIVERS),,video=-16)
